/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.query.JoinType;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.JPAQueryMixin;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.JPAProvider;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;

public class JPAUpdateClause
implements UpdateClause<JPAUpdateClause> {
    private final QueryMixin queryMixin = new JPAQueryMixin();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;
    @Nullable
    private LockModeType lockMode;

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPAUpdateClause(EntityManager em, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = em;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.queryMixin.getMetadata());
        Map constants = serializer.getConstantToLabel();
        Query query = this.entityManager.createQuery(serializer.toString());
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        JPAUtil.setConstants(query, constants, this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    public <T> JPAUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.queryMixin.addProjection((Expression)ExpressionUtils.eqConst(path, value));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.queryMixin.addProjection((Expression)ExpressionUtils.eq(path, expression));
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> JPAUpdateClause setNull(Path<T> path) {
        this.queryMixin.addProjection((Expression)ExpressionUtils.eq(path, (Expression)new NullExpression(path.getType())));
        return this;
    }

    public JPAUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.queryMixin.addProjection((Expression)ExpressionUtils.eqConst((Expression)((Expression)paths.get(i)), values.get(i)));
                continue;
            }
            this.queryMixin.addProjection((Expression)ExpressionUtils.eq((Expression)((Expression)paths.get(i)), (Expression)new NullExpression(paths.get(i).getType())));
        }
        return this;
    }

    public JPAUpdateClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.queryMixin.where(p);
        }
        return this;
    }

    public JPAUpdateClause setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForUpdate(this.queryMixin.getMetadata());
        return serializer.toString();
    }

    public boolean isEmpty() {
        return this.queryMixin.getMetadata().getProjection().isEmpty();
    }
}

