/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.ImmutableMap;
import com.mysema.query.jpa.DefaultQueryHandler;
import com.mysema.query.jpa.JPQLOps;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.QueryHandler;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.PathType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HQLTemplates
extends JPQLTemplates {
    private static final QueryHandler QUERY_HANDLER;
    private static final List<Operator<?>> wrapElements;
    public static final HQLTemplates DEFAULT;
    private final Map<Class<?>, String> typeNames;

    public HQLTemplates() {
        this('!');
    }

    public HQLTemplates(char escape) {
        super(escape, QUERY_HANDLER);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Byte.class, (Object)"byte");
        builder.put(Short.class, (Object)"short");
        builder.put(Integer.class, (Object)"integer");
        builder.put(Long.class, (Object)"long");
        builder.put(BigInteger.class, (Object)"big_integer");
        builder.put(Float.class, (Object)"float");
        builder.put(Double.class, (Object)"double");
        builder.put(BigDecimal.class, (Object)"big_decimal");
        this.typeNames = builder.build();
        this.add(JPQLOps.MEMBER_OF, "{0} in elements({1})");
        this.add(JPQLOps.NOT_MEMBER_OF, "{0} not in elements({1})");
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.MAPVALUE_CONSTANT}) {
            this.add((Operator)type, "{0}[{1}]");
        }
        this.add((Operator)PathType.LISTVALUE_CONSTANT, "{0}[{1s}]");
        this.add((Operator)PathType.COLLECTION_ANY, "any elements({0})");
        this.add(Ops.CONTAINS_KEY, "{1} in indices({0})");
        this.add(Ops.CONTAINS_VALUE, "{1} in elements({0})");
        try {
            Class<?> cl = Class.forName("com.mysema.query.spatial.hibernate.HibernateSpatialSupport");
            this.add((Map)cl.getMethod("getSpatialOps", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean wrapElements(Operator<?> operator) {
        return wrapElements.contains(operator);
    }

    @Override
    public boolean isTypeAsString() {
        return true;
    }

    @Override
    public String getTypeForCast(Class<?> cl) {
        return this.typeNames.get(cl);
    }

    @Override
    public String getExistsProjection() {
        return "1";
    }

    @Override
    public boolean isSelect1Supported() {
        return false;
    }

    @Override
    public boolean isEnumInPathSupported() {
        return false;
    }

    @Override
    public boolean wrapConstant(Object constant) {
        Class<?> type = constant.getClass();
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    @Override
    public boolean isWithForOn() {
        return true;
    }

    @Override
    public boolean isCaseWithLiterals() {
        return true;
    }

    static {
        QueryHandler instance;
        try {
            instance = (QueryHandler)Class.forName("com.mysema.query.jpa.HibernateHandler").newInstance();
        }
        catch (NoClassDefFoundError e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        catch (Exception e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        QUERY_HANDLER = instance;
        wrapElements = Arrays.asList(Ops.QuantOps.ALL, Ops.QuantOps.ANY, Ops.QuantOps.AVG_IN_COL, Ops.EXISTS);
        DEFAULT = new HQLTemplates();
    }
}

