/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.Lists;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPAQueryMixin;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLSubQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.support.DetachableQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.query.NumberSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import java.util.ArrayList;

public class AbstractJPASubQuery<Q extends AbstractJPASubQuery<Q>>
extends DetachableQuery<Q>
implements JPQLSubQuery {
    private final JPAQueryMixin<Q> queryMixin;

    public AbstractJPASubQuery() {
        this((QueryMetadata)new DefaultQueryMetadata().noValidate());
    }

    public AbstractJPASubQuery(QueryMetadata metadata) {
        super(new JPAQueryMixin(metadata));
        ((DetachableQuery)this).queryMixin.setSelf((Object)this);
        this.queryMixin = (JPAQueryMixin)((DetachableQuery)this).queryMixin;
    }

    public NumberSubQuery<Long> count() {
        StringBuilder count = new StringBuilder("count(");
        ArrayList args = Lists.newArrayList();
        for (JoinExpression join : this.queryMixin.getMetadata().getJoins()) {
            if (join.getType() != JoinType.DEFAULT) continue;
            if (!args.isEmpty()) {
                count.append(", ");
            }
            count.append("{" + args.size() + "}");
            args.add(join.getTarget());
        }
        count.append(")");
        return this.unique(NumberTemplate.create(Long.class, (String)count.toString(), (Object[])args.toArray()));
    }

    public Q from(EntityPath<?> o) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.from((Expression)o));
    }

    @Override
    public Q from(EntityPath<?> ... o) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.from((Expression[])o));
    }

    public <P> Q from(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin((Expression)Expressions.as((Expression)((Path)target), alias)));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(CollectionExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(EntityPath<P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin((Expression)target, (Path)alias));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(MapExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    @Deprecated
    public <P> Q fullJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    public <P> Q innerJoin(CollectionExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public <P> Q innerJoin(EntityPath<P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q innerJoin(MapExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public <P> Q join(CollectionExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join(target, alias));
    }

    @Override
    public <P> Q join(EntityPath<P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(EntityPath<P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q join(MapExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.join(target, alias));
    }

    @Override
    public <P> Q leftJoin(CollectionExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public <P> Q leftJoin(EntityPath<P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q leftJoin(MapExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public <P> Q rightJoin(CollectionExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    public <P> Q rightJoin(EntityPath<P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q rightJoin(MapExpression<?, P> target) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.rightJoin(target, alias));
    }

    public Q on(Predicate condition) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.on(condition));
    }

    @Override
    public Q on(Predicate ... conditions) {
        return (Q)((AbstractJPASubQuery)this.queryMixin.on(conditions));
    }

    @Deprecated
    public Q limit(long l) {
        throw new UnsupportedOperationException("JPQL doesn't support limit on subqueries");
    }

    @Deprecated
    public Q offset(long o) {
        throw new UnsupportedOperationException("JPQL doesn't support offset on subqueries");
    }

    @Deprecated
    public Q orderBy(OrderSpecifier<?> o) {
        throw new UnsupportedOperationException("JPQL doesn't support order by on subqueries");
    }

    @Deprecated
    public Q orderBy(OrderSpecifier<?> ... o) {
        throw new UnsupportedOperationException("JPQL doesn't support order by on subqueries");
    }

    public String toString() {
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            JPQLSerializer serializer = new JPQLSerializer(JPQLTemplates.DEFAULT, null);
            serializer.setStrict(false);
            serializer.serialize(this.queryMixin.getMetadata(), false, null);
            return serializer.toString().trim();
        }
        return super.toString();
    }
}

