/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.JPAQueryBase;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.QueryHandler;
import com.mysema.query.jpa.impl.JPAProvider;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractJPAQuery<Q extends AbstractJPAQuery<Q>>
extends JPAQueryBase<Q> {
    private static final Logger logger = LoggerFactory.getLogger(JPAQuery.class);
    protected final Multimap<String, Object> hints = HashMultimap.create();
    protected final EntityManager entityManager;
    protected final QueryHandler queryHandler;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    @Nullable
    protected FactoryExpression<?> projection;

    public AbstractJPAQuery(EntityManager em) {
        this(em, JPAProvider.getTemplates(em), (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPAQuery(EntityManager em, JPQLTemplates templates, QueryMetadata metadata) {
        super(metadata, templates);
        this.queryHandler = templates.getQueryHandler();
        this.entityManager = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        try {
            Query query = this.createQuery(null, true);
            long l = (Long)query.getSingleResult();
            return l;
        }
        finally {
            this.reset();
        }
    }

    public Query createQuery(Expression<?> expr) {
        this.queryMixin.addProjection(expr);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    public Query createQuery(Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        this.queryMixin.addProjection(expr1);
        this.queryMixin.addProjection(expr2);
        this.queryMixin.addProjection(rest);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    public Query createQuery(Expression<?>[] args) {
        this.queryMixin.addProjection(args);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    private Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        FactoryExpression wrapped;
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString, serializer.getConstantToLabel());
        Query query = this.entityManager.createQuery(queryString);
        JPAUtil.setConstants(query, serializer.getConstantToLabel(), this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                query.setFirstResult(offset.intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entries()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        List projection = this.getMetadata().getProjection();
        FactoryExpression factoryExpression = wrapped = projection.size() > 1 ? FactoryExpressionUtils.wrap((List)projection) : null;
        if (!forCount && (projection.size() == 1 && projection.get(0) instanceof FactoryExpression || wrapped != null)) {
            FactoryExpression expr;
            Object object = expr = wrapped != null ? wrapped : (Expression)projection.get(0);
            if (!this.queryHandler.transform(query, expr)) {
                this.projection = (FactoryExpression)projection.get(0);
                if (wrapped != null) {
                    this.projection = wrapped;
                    this.getMetadata().clearProjection();
                    this.getMetadata().addProjection((Expression)wrapped);
                }
            }
        }
        return query;
    }

    private List<?> getResultList(Query query) {
        if (this.projection != null) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(this.projection.newInstance((Object[])o));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(Query query) {
        if (this.projection != null) {
            Object[] result = query.getSingleResult();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return this.projection.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> CloseableIterator<RT> iterate(Expression<RT> expr) {
        try {
            Query query = this.createQuery(expr);
            CloseableIterator closeableIterator = this.queryHandler.iterate(query, this.projection);
            return closeableIterator;
        }
        finally {
            this.reset();
        }
    }

    public List<Tuple> list(Expression<?> ... args) {
        return this.list((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> List<RT> list(Expression<RT> expr) {
        try {
            Query query = this.createQuery(expr);
            List<?> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        try {
            this.queryMixin.addProjection(expr);
            Query countQuery = this.createQuery(null, true);
            long total = (Long)countQuery.getSingleResult();
            if (total > 0L) {
                QueryModifiers modifiers = this.getMetadata().getModifiers();
                Query query = this.createQuery(modifiers, false);
                List<?> list = this.getResultList(query);
                SearchResults searchResults = new SearchResults(list, modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        String normalizedQuery = queryString.replace('\n', ' ');
        MDC.put((String)"querydsl.query", (String)normalizedQuery);
        MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
        if (logger.isDebugEnabled()) {
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    @Override
    protected void reset() {
        super.reset();
        this.cleanupMDC();
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.queryMixin.addProjection(expr);
        return this.uniqueResult();
    }

    @Nullable
    private <RT> RT uniqueResult() {
        try {
            Query query = this.createQuery(this.getMetadata().getModifiers(), false);
            Object object = this.getSingleResult(query);
            return (RT)object;
        }
        catch (NoResultException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            RT RT = null;
            return RT;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)this;
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)this;
    }

    public Q setHint(String name, Object value) {
        this.hints.put((Object)name, value);
        return (Q)this;
    }

    @Override
    protected JPQLSerializer createSerializer() {
        return new JPQLSerializer(this.getTemplates(), this.entityManager);
    }

    protected void clone(Q query) {
        this.projection = ((AbstractJPAQuery)query).projection;
        this.flushMode = ((AbstractJPAQuery)query).flushMode;
        this.hints.putAll(((AbstractJPAQuery)query).hints);
        this.lockMode = ((AbstractJPAQuery)query).lockMode;
    }

    public abstract Q clone(EntityManager var1);

    public abstract Q clone(EntityManager var1, JPQLTemplates var2);

    @Override
    public Q clone() {
        return this.clone(this.entityManager, this.getTemplates());
    }
}

