/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Query;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.impl.DefaultSessionHolder;
import com.mysema.query.jpa.impl.JPASessionHolder;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.query.ListSubQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPASQLQuery<Q extends AbstractJPASQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJPASQLQuery.class);
    @Nullable
    private Map<Object, String> constants;
    private final JPASessionHolder session;
    protected final SQLTemplates sqlTemplates;
    protected final Map<String, Object> hints = new HashMap<String, Object>();
    @Nullable
    protected SubQueryExpression<?>[] union;
    private boolean unionAll;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;

    public AbstractJPASQLQuery(EntityManager entityManager, SQLTemplates sqlTemplates) {
        this(new DefaultSessionHolder(entityManager), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPASQLQuery(JPASessionHolder session, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.sqlTemplates = sqlTemplates;
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.sqlTemplates);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata().getOrderBy(), this.unionAll);
        } else {
            if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
                throw new IllegalArgumentException("No joins given");
            }
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    public javax.persistence.Query createQuery(Expression<?> ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Path || args[i] instanceof FactoryExpression) continue;
            args[i] = ExpressionUtils.as(args[i], (String)("col" + (i + 1)));
        }
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addToProjection(args);
        return this.createQuery(this.toQueryString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private javax.persistence.Query createQuery(String queryString) {
        javax.persistence.Query query;
        this.logQuery(queryString);
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.get(0) instanceof EntityPath) {
            if (projection.size() != 1) throw new IllegalArgumentException("Only single element entity projections are supported");
            query = this.session.createSQLQuery(queryString, ((Expression)projection.get(0)).getType());
        } else {
            query = this.session.createSQLQuery(queryString);
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
            query.setHint(entry.getKey(), entry.getValue());
        }
        JPAUtil.setConstants(query, this.constants, this.queryMixin.getMetadata().getParams());
        return query;
    }

    public List<Object[]> list(Expression<?>[] args) {
        javax.persistence.Query query = this.createQuery(args);
        this.reset();
        return query.getResultList();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        javax.persistence.Query query = this.createQuery(projection);
        this.reset();
        return query.getResultList();
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addToProjection(new Expression[]{projection});
        javax.persistence.Query query = this.createQuery(this.toCountRowsString());
        long total = ((Integer)query.getSingleResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List list = query.getResultList();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = sq;
        return new UnionImpl((Query)this, this.union[0].getMetadata().getProjection());
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        javax.persistence.Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    public Object[] uniqueResult(Expression<?>[] args) {
        javax.persistence.Query query = this.createQuery(args);
        Object obj = this.uniqueResult(query);
        if (obj != null) {
            Object[] objectArray;
            if (obj.getClass().isArray()) {
                objectArray = (Object[])obj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = obj;
            }
            return objectArray;
        }
        return null;
    }

    @Nullable
    private Object uniqueResult(javax.persistence.Query query) {
        this.reset();
        try {
            return query.getSingleResult();
        }
        catch (NoResultException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put(name, value);
        return (Q)((Object)this);
    }
}

