/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final List<Path<?>> entityPaths = new ArrayList();

    public NativeSQLSerializer(SQLTemplates templates) {
        super(templates);
    }

    public Void visit(Constant<?> expr, Void context) {
        if (expr.getConstant() instanceof Collection) {
            this.append(new String[]{"("});
            boolean first = true;
            for (Object element : (Collection)expr.getConstant()) {
                if (!first) {
                    this.append(new String[]{", "});
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(new String[]{")"});
        } else {
            this.visitConstant(expr.getConstant());
        }
        return null;
    }

    private void visitConstant(Object constant) {
        if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append(new String[]{"?" + constLabel});
        } else {
            this.append(new String[]{"?" + (String)this.getConstantToLabel().get(constant)});
        }
    }

    public Void visit(Path<?> path, Void context) {
        if (path.getMetadata().getParent() == null && path.getType().isAnnotationPresent(Entity.class)) {
            super.visit(path, context);
            if (this.stage == SQLSerializer.Stage.SELECT) {
                this.append(new String[]{".*"});
            }
            this.entityPaths.add(path);
        } else {
            super.visit(path, context);
        }
        return null;
    }

    public List<Path<?>> getEntityPaths() {
        return this.entityPaths;
    }
}

