/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.ComparableOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;

public final class JPQLGrammar {
    private JPQLGrammar() {
    }

    public static <D> Expression<D> all(CollectionExpression<?, D> col) {
        return SimpleOperation.create((Class)col.getParameter(0), (Operator)Ops.QuantOps.ALL, (Expression[])new Expression[]{col});
    }

    public static <D> Expression<D> any(CollectionExpression<?, D> col) {
        return SimpleOperation.create((Class)col.getParameter(0), (Operator)Ops.QuantOps.ANY, (Expression[])new Expression[]{col});
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> avg(CollectionExpression<?, A> col) {
        return ComparableOperation.create((Class)col.getParameter(0), (Operator)Ops.QuantOps.AVG_IN_COL, (Expression[])new Expression[]{col});
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> max(CollectionExpression<?, A> left) {
        return ComparableOperation.create((Class)left.getParameter(0), (Operator)Ops.QuantOps.MAX_IN_COL, (Expression[])new Expression[]{left});
    }

    public static <A extends Comparable<? super A>> ComparableExpression<A> min(CollectionExpression<?, A> left) {
        return ComparableOperation.create((Class)left.getParameter(0), (Operator)Ops.QuantOps.MIN_IN_COL, (Expression[])new Expression[]{left});
    }

    public static <D> Expression<D> some(CollectionExpression<?, D> col) {
        return JPQLGrammar.any(col);
    }

    public static <D extends Number> NumberExpression<?> sum(Expression<D> left) {
        Class type = left.getType();
        if (type.equals(Byte.class) || type.equals(Integer.class) || type.equals(Short.class)) {
            type = Long.class;
        } else if (type.equals(Float.class)) {
            type = Double.class;
        }
        return NumberOperation.create(type, (Operator)Ops.AggOps.SUM_AGG, (Expression[])new Expression[]{left});
    }

    public static <D extends Number> NumberExpression<Long> sumAsLong(Expression<D> left) {
        return JPQLGrammar.sum(left).longValue();
    }

    public static <D extends Number> NumberExpression<Double> sumAsDouble(Expression<D> left) {
        return JPQLGrammar.sum(left).doubleValue();
    }

    public static StringExpression type(EntityPath<?> path) {
        return StringOperation.create(JPQLTemplates.TYPE, (Expression[])new Expression[]{path});
    }
}

