/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQueryBase;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.DefaultSessionHolder;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASessionHolder;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPAQuery<Q extends AbstractJPAQuery<Q>>
extends JPQLQueryBase<Q> {
    private static final Logger logger = LoggerFactory.getLogger(JPAQuery.class);
    private final JPASessionHolder sessionHolder;
    private final Map<String, Object> hints = new HashMap<String, Object>();
    @Nullable
    private LockModeType lockMode;
    private Class<?> hibernateQueryClass;
    private boolean factoryExpressionUsed = false;

    public AbstractJPAQuery(EntityManager em) {
        this(new DefaultSessionHolder(em), HQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPAQuery(JPASessionHolder sessionHolder, JPQLTemplates patterns, QueryMetadata metadata) {
        super(metadata, patterns);
        this.sessionHolder = sessionHolder;
        try {
            this.hibernateQueryClass = Class.forName("org.hibernate.ejb.HibernateQuery");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    public long count() {
        String queryString = this.toCountRowsString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, null);
        this.reset();
        return (Long)query.getSingleResult();
    }

    public Query createQuery(Expression<?> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        this.getQueryMixin().addToProjection(new Expression[]{expr1, expr2});
        this.getQueryMixin().addToProjection(rest);
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    public Query createQuery(Expression<?>[] args) {
        this.getQueryMixin().addToProjection(args);
        String queryString = this.toString();
        this.logQuery(queryString);
        return this.createQuery(queryString, this.getMetadata().getModifiers());
    }

    private Query createQuery(String queryString, @Nullable QueryModifiers modifiers) {
        Expression expr;
        Query query = this.sessionHolder.createQuery(queryString);
        JPAUtil.setConstants(query, this.getConstants(), this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            if (modifiers.getLimit() != null) {
                query.setMaxResults(modifiers.getLimit().intValue());
            }
            if (modifiers.getOffset() != null) {
                query.setFirstResult(modifiers.getOffset().intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        for (Map.Entry<String, Object> entry : this.hints.entrySet()) {
            query.setHint(entry.getKey(), entry.getValue());
        }
        List projection = this.getMetadata().getProjection();
        if (projection.size() == 1 && (expr = (Expression)projection.get(0)) instanceof FactoryExpression) {
            if (this.hibernateQueryClass != null && this.hibernateQueryClass.isInstance(query)) {
                try {
                    Class<?> cl = Class.forName("com.mysema.query.jpa.impl.HibernateQueryTransformation");
                    cl.getConstructor(Query.class, FactoryExpression.class).newInstance(query, expr);
                }
                catch (ClassNotFoundException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new QueryException(e.getMessage(), (Throwable)e);
                }
            } else {
                this.factoryExpressionUsed = true;
            }
        }
        return query;
    }

    private List<?> getResultList(Query query) {
        if (this.factoryExpressionUsed) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            FactoryExpression expr = (FactoryExpression)this.getMetadata().getProjection().get(0);
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(expr.newInstance((Object[])o));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    private Object getSingleResult(Query query) {
        if (this.factoryExpressionUsed) {
            Object[] result = query.getSingleResult();
            FactoryExpression expr = (FactoryExpression)this.getMetadata().getProjection().get(0);
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return expr.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> list(Expression<?>[] args) {
        Query query = this.createQuery(args);
        try {
            List<Object[]> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> List<RT> list(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        try {
            List<?> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        Query query = this.createQuery(this.toCountRowsString(), null);
        long total = (Long)query.getSingleResult();
        if (total > 0L) {
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            String queryString = this.toString();
            this.logQuery(queryString);
            query = this.createQuery(queryString, modifiers);
            List<?> list = this.getResultList(query);
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.getQueryMixin().addToProjection(new Expression[]{expr});
        return (RT)this.uniqueResult();
    }

    public Object[] uniqueResult(Expression<?>[] args) {
        this.getQueryMixin().addToProjection(args);
        return (Object[])this.uniqueResult();
    }

    @Nullable
    private Object uniqueResult() {
        String queryString = this.toQueryString();
        this.logQuery(queryString);
        Query query = this.createQuery(queryString, this.getMetadata().getModifiers());
        try {
            Object object = this.getSingleResult(query);
            return object;
        }
        catch (NoResultException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            Object var4_6 = null;
            return var4_6;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put(name, value);
        return (Q)((Object)this);
    }
}

