/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpressionBase;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Visitor;
import com.mysema.query.util.ConstructorUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConstructorExpression<T>
extends FactoryExpressionBase<T> {
    private static final long serialVersionUID = -602747921848073175L;
    private final ImmutableList<Expression<?>> args;
    private final Class<?>[] parameterTypes;
    @Nullable
    private transient Constructor<?> constructor;
    private transient Iterable<Function<Object[], Object[]>> transformers;

    public static <D> ConstructorExpression<D> create(Class<D> type, Expression<?> ... args) {
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = args[i].getType();
        }
        return new ConstructorExpression<D>(type, paramTypes, args);
    }

    public ConstructorExpression(Class<T> type, Class<?>[] paramTypes, Expression<?> ... args) {
        this(type, paramTypes, ImmutableList.copyOf((Object[])args));
    }

    public ConstructorExpression(Class<T> type, Class<?>[] paramTypes, ImmutableList<Expression<?>> args) {
        super(type);
        this.parameterTypes = (Class[])ConstructorUtils.getConstructorParameters(type, paramTypes).clone();
        this.args = args;
    }

    public Expression<T> as(Path<T> alias) {
        return OperationImpl.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public Expression<T> as(String alias) {
        return this.as(new PathImpl(this.getType(), alias));
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConstructorExpression) {
            ConstructorExpression c = (ConstructorExpression)obj;
            return Arrays.equals(this.parameterTypes, c.parameterTypes) && this.args.equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public final List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public T newInstance(Object ... args) {
        try {
            if (this.constructor == null) {
                this.constructor = ConstructorUtils.getConstructor(this.getType(), this.parameterTypes);
                this.transformers = ConstructorUtils.getTransformers(this.constructor);
            }
            for (Function<Object[], Object[]> transformer : this.transformers) {
                args = (Object[])transformer.apply((Object)args);
            }
            return (T)this.constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }
}

