/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.template;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EnumExpression;
import java.util.List;

public class EnumTemplate<T extends Enum<T>>
extends EnumExpression<T>
implements TemplateExpression<T> {
    private static final long serialVersionUID = 351057421752203377L;
    private final TemplateExpressionImpl<T> templateMixin;

    public static <T extends Enum<T>> EnumExpression<T> create(Class<T> type, String template) {
        return new EnumTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of());
    }

    public static <T extends Enum<T>> EnumExpression<T> create(Class<T> type, String template, Object one) {
        return new EnumTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one));
    }

    public static <T extends Enum<T>> EnumExpression<T> create(Class<T> type, String template, Object one, Object two) {
        return new EnumTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one, (Object)two));
    }

    public static <T extends Enum<T>> EnumExpression<T> create(Class<T> type, String template, Object ... args) {
        return new EnumTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.copyOf((Object[])args));
    }

    public static <T extends Enum<T>> EnumExpression<T> create(Class<T> type, Template template, Object ... args) {
        return new EnumTemplate<T>(type, template, ImmutableList.copyOf((Object[])args));
    }

    public EnumTemplate(Class<T> type, Template template, ImmutableList<?> args) {
        super(new TemplateExpressionImpl<T>(type, template, args));
        this.templateMixin = (TemplateExpressionImpl)this.mixin;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.templateMixin, context);
    }

    @Override
    public Object getArg(int index) {
        return this.templateMixin.getArg(index);
    }

    @Override
    public List<?> getArgs() {
        return this.templateMixin.getArgs();
    }

    @Override
    public Template getTemplate() {
        return this.templateMixin.getTemplate();
    }
}

