/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.CollectionExpressionBase;
import java.util.Collection;
import javax.annotation.Nullable;

public class CollectionOperation<E>
extends CollectionExpressionBase<Collection<E>, E> {
    private static final long serialVersionUID = 3154315192589335574L;
    private final Class<E> elementType;
    private final OperationImpl<Collection<E>> opMixin;

    public static <E> CollectionOperation<E> create(Operator<?> op, Class<E> type, Expression<?> one) {
        return new CollectionOperation<E>(op, type, ImmutableList.of(one));
    }

    public static <E> CollectionOperation<E> create(Operator<?> op, Class<E> type, Expression<?> one, Expression<?> two) {
        return new CollectionOperation<E>(op, type, ImmutableList.of(one, two));
    }

    public static <E> CollectionOperation<E> create(Operator<?> op, Class<E> type, Expression<?> ... args) {
        return new CollectionOperation<E>(op, type, args);
    }

    public CollectionOperation(Operator<?> op, Class<? super E> type, Expression<?> ... args) {
        this(op, type, ImmutableList.copyOf((Object[])args));
    }

    public CollectionOperation(Operator<?> op, Class<? super E> type, ImmutableList<Expression<?>> args) {
        super(new OperationImpl<Collection>(Collection.class, op, args));
        this.opMixin = (OperationImpl)this.mixin;
        this.elementType = type;
    }

    @Override
    public Class<?> getParameter(int index) {
        if (index == 0) {
            return this.elementType;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    @Nullable
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return this.opMixin.accept(v, context);
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }
}

