/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinFlag;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.Tuple;
import com.mysema.query.support.CollectionAnyVisitor;
import com.mysema.query.support.Context;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.ProjectionRole;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.SubQueryExpression;

public class QueryMixin<T> {
    private final QueryMetadata metadata;
    private final boolean expandAnyPaths;
    private T self;

    public QueryMixin() {
        this.metadata = new DefaultQueryMetadata();
        this.expandAnyPaths = true;
    }

    public QueryMixin(QueryMetadata metadata) {
        this.metadata = metadata;
        this.expandAnyPaths = true;
    }

    public QueryMixin(QueryMetadata metadata, boolean expandAnyPaths) {
        this.metadata = metadata;
        this.expandAnyPaths = expandAnyPaths;
    }

    public QueryMixin(T self) {
        this(self, new DefaultQueryMetadata());
    }

    public QueryMixin(T self, QueryMetadata metadata) {
        this.self = self;
        this.metadata = metadata;
        this.expandAnyPaths = true;
    }

    public QueryMixin(T self, QueryMetadata metadata, boolean expandAnyPaths) {
        this.self = self;
        this.metadata = metadata;
        this.expandAnyPaths = expandAnyPaths;
    }

    public T addJoin(JoinType joinType, Expression<?> target) {
        this.metadata.addJoin(joinType, target);
        return this.self;
    }

    public T addFlag(QueryFlag queryFlag) {
        this.metadata.addFlag(queryFlag);
        return this.self;
    }

    public T addJoinFlag(JoinFlag flag) {
        this.metadata.addJoinFlag(flag);
        return this.self;
    }

    public T removeFlag(QueryFlag queryFlag) {
        this.metadata.removeFlag(queryFlag);
        return this.self;
    }

    public <E> Expression<E> addProjection(Expression<E> e) {
        e = this.convert(e, false);
        this.metadata.addProjection(e);
        return e;
    }

    public T addProjection(Expression<?> ... o) {
        for (Expression<?> e : o) {
            this.metadata.addProjection(this.convert(e, false));
        }
        return this.self;
    }

    private <P extends Path<?>> P assertRoot(P p) {
        if (!p.getRoot().equals(p)) {
            throw new IllegalArgumentException(p + " is not a root path");
        }
        return p;
    }

    public <RT> Expression<RT> convert(Expression<RT> expr, boolean forOrder) {
        Context context;
        Expression replaced;
        if (this.expandAnyPaths && expr instanceof Path && !(replaced = (Expression)expr.accept(CollectionAnyVisitor.DEFAULT, context = new Context())).equals(expr)) {
            for (int i = 0; i < context.paths.size(); ++i) {
                Path<?> path = context.paths.get(i).getMetadata().getParent();
                Path replacement = context.replacements.get(i);
                this.innerJoin(path, replacement);
            }
            return replaced;
        }
        if (expr instanceof ProjectionRole) {
            return this.convert(((ProjectionRole)((Object)expr)).getProjection(), forOrder);
        }
        if (expr instanceof FactoryExpression && !(expr instanceof FactoryExpressionUtils.FactoryExpressionAdapter)) {
            return FactoryExpressionUtils.wrap((FactoryExpression)expr);
        }
        return expr;
    }

    public Expression<Tuple> createProjection(Expression<?>[] args) {
        return new QTuple(args);
    }

    protected <D> Expression<D> createAlias(Expression<?> expr, Path<?> alias) {
        this.assertRoot(alias);
        return ExpressionUtils.as(expr, alias);
    }

    public final T distinct() {
        this.metadata.setDistinct(true);
        return this.self;
    }

    public final T from(Expression<?> arg) {
        this.metadata.addJoin(JoinType.DEFAULT, arg);
        return this.self;
    }

    public final T from(Expression<?> ... args) {
        for (Expression<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public final T fullJoin(Expression<?> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public final <P> T fullJoin(Expression<P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T fullJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T fullJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T fullJoin(SubQueryExpression<P> target, Path<?> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final QueryMetadata getMetadata() {
        return this.metadata;
    }

    public final T getSelf() {
        return this.self;
    }

    public final T groupBy(Expression<?> e) {
        this.metadata.addGroupBy(e);
        return this.self;
    }

    public final T groupBy(Expression<?> ... o) {
        for (Expression<?> e : o) {
            this.metadata.addGroupBy(e);
        }
        return this.self;
    }

    public final T having(Predicate e) {
        this.metadata.addHaving(this.normalize(e, false));
        return this.self;
    }

    public final T having(Predicate ... o) {
        for (Predicate e : o) {
            this.metadata.addHaving(this.normalize(e, false));
        }
        return this.self;
    }

    public final <P> T innerJoin(Expression<P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public final <P> T innerJoin(Expression<P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T innerJoin(SubQueryExpression<P> target, Path<?> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final boolean isDistinct() {
        return this.metadata.isDistinct();
    }

    public final boolean isUnique() {
        return this.metadata.isUnique();
    }

    public final <P> T join(Expression<P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.self;
    }

    public final <P> T join(Expression<P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T join(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T join(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T join(SubQueryExpression<P> target, Path<?> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T leftJoin(Expression<P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.self;
    }

    public final <P> T leftJoin(Expression<P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T leftJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T leftJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T leftJoin(SubQueryExpression<P> target, Path<?> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final T limit(long limit) {
        this.metadata.setLimit(limit);
        return this.self;
    }

    public final T offset(long offset) {
        this.metadata.setOffset(offset);
        return this.self;
    }

    public final T on(Predicate condition) {
        this.metadata.addJoinCondition(this.normalize(condition, false));
        return this.self;
    }

    public final T on(Predicate ... conditions) {
        for (Predicate condition : conditions) {
            this.metadata.addJoinCondition(this.normalize(condition, false));
        }
        return this.self;
    }

    public final T orderBy(OrderSpecifier<?> spec) {
        Expression<?> e = this.convert(spec.getTarget(), true);
        if (!spec.getTarget().equals(e)) {
            this.metadata.addOrderBy(new OrderSpecifier(spec.getOrder(), e));
        } else {
            this.metadata.addOrderBy(spec);
        }
        return this.self;
    }

    public final T orderBy(OrderSpecifier<?> ... o) {
        for (OrderSpecifier<?> spec : o) {
            this.orderBy(spec);
        }
        return this.self;
    }

    public final T restrict(QueryModifiers modifiers) {
        this.metadata.setModifiers(modifiers);
        return this.self;
    }

    public final <P> T rightJoin(Expression<P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.self;
    }

    public final <P> T rightJoin(Expression<P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T rightJoin(CollectionExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T rightJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public final <P> T rightJoin(SubQueryExpression<P> target, Path<?> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public final <P> T set(ParamExpression<P> param, P value) {
        this.metadata.setParam(param, value);
        return this.self;
    }

    public final void setDistinct(boolean distinct) {
        this.metadata.setDistinct(distinct);
    }

    public final void setSelf(T self) {
        this.self = self;
    }

    public final void setUnique(boolean unique) {
        this.metadata.setUnique(unique);
    }

    public final T where(Predicate e) {
        this.metadata.addWhere(this.normalize(e, true));
        return this.self;
    }

    public final T where(Predicate ... o) {
        for (Predicate e : o) {
            this.metadata.addWhere(this.normalize(e, true));
        }
        return this.self;
    }

    protected Predicate normalize(Predicate condition, boolean where) {
        return condition;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryMixin) {
            QueryMixin q = (QueryMixin)o;
            return q.metadata.equals(this.metadata);
        }
        return false;
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return this.metadata.toString();
    }
}

