/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.Tuple;
import com.mysema.query.group.AbstractGroupByTransformer;
import com.mysema.query.group.Group;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.group.GroupImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.QTuple;
import java.util.ArrayList;
import java.util.List;

public class GroupByList<K, V>
extends AbstractGroupByTransformer<K, List<V>> {
    GroupByList(Expression<K> key, Expression<?> ... expressions) {
        super(key, expressions);
    }

    @Override
    public List<V> transform(Projectable projectable) {
        FactoryExpression<Tuple> expr = FactoryExpressionUtils.wrap(new QTuple((Expression<?>[])this.expressions));
        boolean hasGroups = false;
        for (Expression<?> e : expr.getArgs()) {
            hasGroups |= e instanceof GroupExpression;
        }
        if (hasGroups) {
            expr = GroupByList.withoutGroupExpressions(expr);
        }
        CloseableIterator<Tuple> iter = projectable.iterate(expr);
        ArrayList list = Lists.newArrayList();
        GroupImpl group = null;
        Object groupId = null;
        while (iter.hasNext()) {
            Object[] row = ((Tuple)iter.next()).toArray();
            if (group == null) {
                group = new GroupImpl(this.groupExpressions, this.maps);
                groupId = row[0];
            } else if (!Objects.equal(groupId, (Object)row[0])) {
                list.add(this.transform(group));
                group = new GroupImpl(this.groupExpressions, this.maps);
                groupId = row[0];
            }
            group.add(row);
        }
        if (group != null) {
            list.add(this.transform(group));
        }
        iter.close();
        return list;
    }

    protected V transform(Group group) {
        return (V)group;
    }
}

