/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.template;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.TemplateFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.NumberExpression;
import java.util.List;

public class NumberTemplate<T extends Number>
extends NumberExpression<T>
implements TemplateExpression<T> {
    private static final long serialVersionUID = 351057421752203377L;
    public static final NumberExpression<Integer> ONE = NumberTemplate.create(Integer.class, "1");
    public static final NumberExpression<Integer> TWO = NumberTemplate.create(Integer.class, "2");
    public static final NumberExpression<Integer> THREE = NumberTemplate.create(Integer.class, "3");
    public static final NumberExpression<Integer> ZERO = NumberTemplate.create(Integer.class, "0");
    private final TemplateExpressionImpl<T> templateMixin;

    public static <T extends Number> NumberExpression<T> create(Class<T> type, String template) {
        return new NumberTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of());
    }

    public static <T extends Number> NumberExpression<T> create(Class<T> type, String template, Object one) {
        return new NumberTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one));
    }

    public static <T extends Number> NumberExpression<T> create(Class<T> type, String template, Object one, Object two) {
        return new NumberTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.of((Object)one, (Object)two));
    }

    public static <T extends Number> NumberExpression<T> create(Class<T> type, String template, Object ... args) {
        return new NumberTemplate<T>(type, TemplateFactory.DEFAULT.create(template), ImmutableList.copyOf((Object[])args));
    }

    public static <T extends Number> NumberExpression<T> create(Class<T> type, Template template, Object ... args) {
        return new NumberTemplate<T>(type, template, ImmutableList.copyOf((Object[])args));
    }

    public NumberTemplate(Class<T> type, Template template, ImmutableList<?> args) {
        super(new TemplateExpressionImpl<T>(type, template, args));
        this.templateMixin = (TemplateExpressionImpl)this.mixin;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.templateMixin, context);
    }

    @Override
    public Object getArg(int index) {
        return this.templateMixin.getArg(index);
    }

    @Override
    public List<?> getArgs() {
        return this.templateMixin.getArgs();
    }

    @Override
    public Template getTemplate() {
        return this.templateMixin.getTemplate();
    }
}

