/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.google.common.collect.Maps;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.path.ArrayPath;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.CollectionPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.ListPath;
import com.mysema.query.types.path.MapPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.PathInits;
import com.mysema.query.types.path.SetPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import java.util.Map;

public final class PathBuilder<T>
extends EntityPathBase<T> {
    private static final long serialVersionUID = -1666357914232685088L;
    private final Map<String, PathBuilder<?>> properties = Maps.newHashMap();
    private final Map<Path<?>, Object> propertyMetadata = Maps.newHashMap();

    public PathBuilder(Class<? extends T> type, PathMetadata<?> pathMetadata) {
        super(type, pathMetadata);
    }

    public PathBuilder(Class<? extends T> type, String variable) {
        super(type, PathMetadataFactory.forVariable(variable));
    }

    private <P extends Path<?>> P addMetadataOf(P newPath, Path<?> path) {
        if (path.getMetadata().getParent() instanceof EntityPath) {
            EntityPath parent = (EntityPath)path.getMetadata().getParent();
            this.propertyMetadata.put(newPath, parent.getMetadata(path));
        }
        return newPath;
    }

    protected void validate(String property) {
    }

    @Override
    public Object getMetadata(Path<?> property) {
        return this.propertyMetadata.get(property);
    }

    public PathBuilder<Object> get(String property) {
        PathBuilder<Object> path = this.properties.get(property);
        if (path == null) {
            this.validate(property);
            path = new PathBuilder<Object>(Object.class, this.forProperty(property));
            this.properties.put(property, path);
        }
        return path;
    }

    public <A> PathBuilder<A> get(String property, Class<A> type) {
        PathBuilder<Object> path = this.properties.get(property);
        if (path == null || !type.isAssignableFrom(path.getType())) {
            this.validate(property);
            path = new PathBuilder<A>(type, this.forProperty(property));
            this.properties.put(property, path);
        }
        return path;
    }

    public <A, E> ArrayPath<A, E> getArray(String property, Class<A> type) {
        this.validate(property);
        return super.createArray(property, type);
    }

    public BooleanPath get(BooleanPath path) {
        BooleanPath newPath = this.getBoolean(this.toString(path));
        return this.addMetadataOf(newPath, path);
    }

    public BooleanPath getBoolean(String propertyName) {
        this.validate(propertyName);
        return super.createBoolean(propertyName);
    }

    public <A> CollectionPath<A, PathBuilder<A>> getCollection(String property, Class<A> type) {
        this.validate(property);
        return super.createCollection(property, type, PathBuilder.class, PathInits.DIRECT);
    }

    public <A, E extends SimpleExpression<A>> CollectionPath<A, E> getCollection(String property, Class<A> type, Class<E> queryType) {
        this.validate(property);
        return super.createCollection(property, type, queryType, PathInits.DIRECT);
    }

    public <A extends Comparable<?>> ComparablePath<A> get(ComparablePath<A> path) {
        ComparablePath newPath = this.getComparable(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A extends Comparable<?>> ComparablePath<A> getComparable(String property, Class<A> type) {
        this.validate(property);
        return super.createComparable(property, type);
    }

    public <A extends Comparable<?>> DatePath<A> get(DatePath<A> path) {
        DatePath newPath = this.getDate(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A extends Comparable<?>> DatePath<A> getDate(String property, Class<A> type) {
        this.validate(property);
        return super.createDate(property, type);
    }

    public <A extends Comparable<?>> DateTimePath<A> get(DateTimePath<A> path) {
        DateTimePath newPath = this.getDateTime(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A extends Comparable<?>> DateTimePath<A> getDateTime(String property, Class<A> type) {
        this.validate(property);
        return super.createDateTime(property, type);
    }

    public <A extends Enum<A>> EnumPath<A> getEnum(String property, Class<A> type) {
        this.validate(property);
        return super.createEnum(property, type);
    }

    public <A extends Enum<A>> EnumPath<A> get(EnumPath<A> path) {
        EnumPath newPath = this.getEnum(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A> ListPath<A, PathBuilder<A>> getList(String property, Class<A> type) {
        this.validate(property);
        return super.createList(property, type, PathBuilder.class, PathInits.DIRECT);
    }

    public <A, E extends SimpleExpression<A>> ListPath<A, E> getList(String property, Class<A> type, Class<E> queryType) {
        this.validate(property);
        return super.createList(property, type, queryType, PathInits.DIRECT);
    }

    public <K, V> MapPath<K, V, PathBuilder<V>> getMap(String property, Class<K> key, Class<V> value) {
        this.validate(property);
        return super.createMap(property, key, value, PathBuilder.class);
    }

    public <K, V, E extends SimpleExpression<V>> MapPath<K, V, E> getMap(String property, Class<K> key, Class<V> value, Class<E> queryType) {
        this.validate(property);
        return super.createMap(property, key, value, queryType);
    }

    public <A extends Number> NumberPath<A> get(NumberPath<A> path) {
        NumberPath newPath = this.getNumber(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A extends Number> NumberPath<A> getNumber(String property, Class<A> type) {
        this.validate(property);
        return super.createNumber(property, type);
    }

    public <A> SetPath<A, PathBuilder<A>> getSet(String property, Class<A> type) {
        this.validate(property);
        return super.createSet(property, type, PathBuilder.class, PathInits.DIRECT);
    }

    public <A, E extends SimpleExpression<A>> SetPath<A, E> getSet(String property, Class<A> type, Class<E> queryType) {
        this.validate(property);
        return super.createSet(property, type, queryType, PathInits.DIRECT);
    }

    public <A> SimplePath<A> get(Path<A> path) {
        SimplePath newPath = this.getSimple(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A> SimplePath<A> getSimple(String property, Class<A> type) {
        this.validate(property);
        return super.createSimple(property, type);
    }

    public StringPath get(StringPath path) {
        StringPath newPath = this.getString(this.toString(path));
        return this.addMetadataOf(newPath, path);
    }

    public StringPath getString(String property) {
        this.validate(property);
        return super.createString(property);
    }

    public <A extends Comparable<?>> TimePath<A> get(TimePath<A> path) {
        TimePath newPath = this.getTime(this.toString(path), path.getType());
        return this.addMetadataOf(newPath, path);
    }

    public <A extends Comparable<?>> TimePath<A> getTime(String property, Class<A> type) {
        this.validate(property);
        return super.createTime(property, type);
    }

    private String toString(Path<?> path) {
        return path.getMetadata().getElement().toString();
    }
}

