/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.query.group.AbstractGroupExpression;
import com.mysema.query.group.GAvg;
import com.mysema.query.group.GList;
import com.mysema.query.group.GMap;
import com.mysema.query.group.GMax;
import com.mysema.query.group.GMin;
import com.mysema.query.group.GSet;
import com.mysema.query.group.GSum;
import com.mysema.query.group.GroupByBuilder;
import com.mysema.query.group.QPair;
import com.mysema.query.types.Expression;
import com.mysema.query.types.QList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GroupBy {
    public static <K> GroupByBuilder<K> groupBy(Expression<K> key) {
        return new GroupByBuilder<K>(key);
    }

    public static GroupByBuilder<List<?>> groupBy(Expression<?> ... keys) {
        return new GroupByBuilder(new QList(keys));
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<?, E> min(Expression<E> expression) {
        return new GMin<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<?, E> sum(Expression<E> expression) {
        return new GSum<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<?, E> avg(Expression<E> expression) {
        return new GAvg<E>(expression);
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<?, E> max(Expression<E> expression) {
        return new GMax<E>(expression);
    }

    public static <E> AbstractGroupExpression<?, List<E>> list(Expression<E> expression) {
        return new GList<E>(expression);
    }

    public static <E> AbstractGroupExpression<?, Set<E>> set(Expression<E> expression) {
        return new GSet<E>(expression);
    }

    public static <K, V> Expression<Map<K, V>> map(Expression<K> key, Expression<V> value) {
        QPair<K, V> qPair = new QPair<K, V>(key, value);
        return new GMap<K, V>(qPair);
    }

    private GroupBy() {
    }
}

