/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.MutableExpressionBase;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.ComparableOperation;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.DslExpression;
import com.mysema.query.types.expr.DslOperation;
import com.mysema.query.types.expr.EnumExpression;
import com.mysema.query.types.expr.EnumOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.expr.TimeOperation;
import java.util.ArrayList;
import java.util.List;

public class Coalesce<T extends Comparable>
extends MutableExpressionBase<T> {
    private static final long serialVersionUID = 445439522266250417L;
    private final List<Expression<? extends T>> exprs = new ArrayList<Expression<? extends T>>();
    private volatile ComparableExpression<T> value;

    public Coalesce(Class<? extends T> type, Expression<?> ... exprs) {
        super(type);
        for (Expression<?> expr : exprs) {
            this.add((T)expr);
        }
    }

    public Coalesce(Expression ... exprs) {
        this(exprs.length > 0 ? exprs[0].getType() : Object.class, exprs);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return this.getValue().accept(v, context);
    }

    public ComparableExpression<T> getValue() {
        if (this.value == null) {
            this.value = ComparableOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
        }
        return this.value;
    }

    public DslExpression<T> as(Path<T> alias) {
        return DslOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public DslExpression<T> as(String alias) {
        return this.as(new PathImpl(this.getType(), alias));
    }

    public final Coalesce<T> add(Expression<T> expr) {
        this.value = null;
        this.exprs.add(expr);
        return this;
    }

    public OrderSpecifier<T> asc() {
        return this.getValue().asc();
    }

    public OrderSpecifier<T> desc() {
        return this.getValue().desc();
    }

    public final Coalesce<T> add(T constant) {
        return this.add((T)new ConstantImpl<T>(constant));
    }

    public BooleanExpression asBoolean() {
        return BooleanOperation.create(Ops.COALESCE, this.getExpressionList());
    }

    public DateExpression<T> asDate() {
        return DateOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public DateTimeExpression<T> asDateTime() {
        return DateTimeOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public EnumExpression<?> asEnum() {
        return EnumOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public NumberExpression<?> asNumber() {
        return NumberOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public StringExpression asString() {
        return StringOperation.create(Ops.COALESCE, this.getExpressionList());
    }

    public TimeExpression<T> asTime() {
        return TimeOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    private Expression<?> getExpressionList() {
        return ExpressionUtils.list(this.getType(), this.exprs);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Coalesce) {
            Coalesce c = (Coalesce)o;
            return c.exprs.equals(this.exprs);
        }
        return false;
    }
}

