/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import com.mysema.util.MathUtils;
import java.util.List;

public class NumberConversions<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = -7834053123363933721L;
    private final FactoryExpression<T> expr;

    public NumberConversions(FactoryExpression<T> expr) {
        super(expr.getType());
        this.expr = expr;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.expr.getArgs();
    }

    @Override
    public T newInstance(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = this.expr.getArgs().get(i).getType();
            if (!(args[i] instanceof Number) || args[i].getClass().equals(type)) continue;
            args[i] = type.equals(Boolean.class) ? Boolean.valueOf(((Number)args[i]).intValue() > 0) : MathUtils.cast((Number)args[i], type);
        }
        return this.expr.newInstance(args);
    }
}

