/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.ResultTransformer;
import com.mysema.query.Tuple;
import com.mysema.query.group.AbstractGroupExpression;
import com.mysema.query.group.GAvg;
import com.mysema.query.group.GList;
import com.mysema.query.group.GMap;
import com.mysema.query.group.GMax;
import com.mysema.query.group.GMin;
import com.mysema.query.group.GOne;
import com.mysema.query.group.GSet;
import com.mysema.query.group.GSum;
import com.mysema.query.group.Group;
import com.mysema.query.group.GroupByBuilder;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.group.GroupImpl;
import com.mysema.query.group.QPair;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.QTuple;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupBy<K, V>
implements ResultTransformer<Map<K, V>> {
    protected final List<GroupExpression<?, ?>> groupExpressions = new ArrayList();
    protected final List<QPair<?, ?>> maps = new ArrayList();
    protected final Expression<?>[] expressions;

    public static <K> GroupByBuilder<K> groupBy(Expression<K> key) {
        return new GroupByBuilder<K>(key);
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<?, E> min(Expression<E> expression) {
        return new GMin<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<?, E> sum(Expression<E> expression) {
        return new GSum<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<?, E> avg(Expression<E> expression) {
        return new GAvg<E>(expression);
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<?, E> max(Expression<E> expression) {
        return new GMax<E>(expression);
    }

    public static <E> AbstractGroupExpression<?, List<E>> list(Expression<E> expression) {
        return new GList<E>(expression);
    }

    public static <E> AbstractGroupExpression<?, Set<E>> set(Expression<E> expression) {
        return new GSet<E>(expression);
    }

    public static <K, V> Expression<Map<K, V>> map(Expression<K> key, Expression<V> value) {
        QPair<K, V> qPair = new QPair<K, V>(key, value);
        return new GMap<K, V>(qPair);
    }

    GroupBy(Expression<K> key, Expression<?> ... expressions) {
        ArrayList projection = new ArrayList(expressions.length);
        this.groupExpressions.add(new GOne<K>(key));
        projection.add(key);
        for (Expression<?> expr : expressions) {
            if (expr instanceof GroupExpression) {
                GroupExpression groupExpr = (GroupExpression)expr;
                this.groupExpressions.add(groupExpr);
                projection.add(groupExpr.getExpression());
                if (!(groupExpr instanceof GMap)) continue;
                this.maps.add((QPair)groupExpr.getExpression());
                continue;
            }
            this.groupExpressions.add(new GOne(expr));
            projection.add(expr);
        }
        this.expressions = projection.toArray(new Expression[projection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> transform(Projectable projectable) {
        LinkedHashMap<Object, GroupImpl> groups = new LinkedHashMap<Object, GroupImpl>();
        FactoryExpression<Tuple> expr = FactoryExpressionUtils.wrap(new QTuple(this.expressions));
        CloseableIterator<Tuple> iter = projectable.iterate(expr);
        try {
            while (iter.hasNext()) {
                Object[] row = ((Tuple)iter.next()).toArray();
                Object groupId = row[0];
                GroupImpl group = (GroupImpl)groups.get(groupId);
                if (group == null) {
                    group = new GroupImpl(this.groupExpressions, this.maps);
                    groups.put(groupId, group);
                }
                group.add(row);
            }
        }
        finally {
            iter.close();
        }
        return this.transform(groups);
    }

    protected Map<K, V> transform(Map<K, Group> groups) {
        return groups;
    }
}

