/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.query;

import com.mysema.query.QueryMetadata;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.SubQueryExpressionImpl;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.CollectionExpressionBase;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.query.ExtendedSubQueryExpression;
import com.mysema.query.types.query.NumberSubQuery;
import java.util.List;
import javax.annotation.Nullable;

public final class ListSubQuery<T>
extends CollectionExpressionBase<List<T>, T>
implements ExtendedSubQueryExpression<List<T>> {
    private static final long serialVersionUID = 3399354334765602960L;
    private final Class<T> elementType;
    private final SubQueryExpression<List<T>> subQueryMixin;
    @Nullable
    private volatile BooleanExpression exists;
    @Nullable
    private volatile NumberExpression<Long> count;
    @Nullable
    private volatile NumberExpression<Long> countDistinct;

    public ListSubQuery(Class<T> elementType, QueryMetadata md) {
        super(new SubQueryExpressionImpl<List>(List.class, md));
        this.elementType = elementType;
        this.subQueryMixin = (SubQueryExpression)this.mixin;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public NumberExpression<Long> count() {
        if (this.count == null) {
            this.count = this.count(Ops.AggOps.COUNT_AGG);
        }
        return this.count;
    }

    public NumberExpression<Long> countDistinct() {
        if (this.countDistinct == null) {
            this.countDistinct = this.count(Ops.AggOps.COUNT_DISTINCT_AGG);
        }
        return this.countDistinct;
    }

    private NumberExpression<Long> count(Operator<Number> operator) {
        QueryMetadata md = this.subQueryMixin.getMetadata().clone();
        Expression<?> e = null;
        e = md.getProjection().size() == 1 ? md.getProjection().get(0) : ExpressionUtils.merge(md.getProjection());
        md.clearProjection();
        md.addProjection(OperationImpl.create(Long.class, operator, e));
        return new NumberSubQuery<Long>(Long.class, md);
    }

    @Override
    public BooleanExpression exists() {
        if (this.exists == null) {
            this.exists = BooleanOperation.create(Ops.EXISTS, this);
        }
        return this.exists;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public QueryMetadata getMetadata() {
        return this.subQueryMixin.getMetadata();
    }

    @Override
    public BooleanExpression notExists() {
        return this.exists().not();
    }

    @Override
    public SimpleExpression<?> as(Expression<?> alias) {
        return SimpleOperation.create(alias.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public Class<?> getParameter(int index) {
        if (index == 0) {
            return this.elementType;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }
}

