/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Objects;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class PathMetadata<T>
implements Serializable {
    private static final long serialVersionUID = -1055994185028970065L;
    private final Expression<T> expression;
    private final int hashCode;
    @Nullable
    private final Path<?> parent;
    @Nullable
    private final Path<?> root;
    private final PathType pathType;

    public PathMetadata(@Nullable Path<?> parent, Expression<T> expression, PathType type) {
        this.parent = parent;
        this.expression = expression;
        this.pathType = type;
        this.root = parent != null ? parent.getRoot() : null;
        this.hashCode = Objects.hashCode((Object[])new Object[]{expression, parent, this.pathType});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathMetadata) {
            PathMetadata p = (PathMetadata)obj;
            return Objects.equal(this.expression, p.expression) && Objects.equal(this.parent, p.parent) && Objects.equal((Object)this.pathType, (Object)p.pathType);
        }
        return false;
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    @Nullable
    public Path<?> getParent() {
        return this.parent;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    @Nullable
    public Path<?> getRoot() {
        return this.root;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isRoot() {
        return this.parent == null;
    }
}

