/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.query.group.AbstractGroupExpression;
import com.mysema.query.group.GroupCollector;
import com.mysema.query.types.Expression;
import com.mysema.util.MathUtils;
import java.math.BigDecimal;

public class GSum<T extends Number>
extends AbstractGroupExpression<T, T> {
    private static final long serialVersionUID = 3518868612387641383L;

    public GSum(Expression<T> expr) {
        super(expr.getType(), expr);
    }

    @Override
    public GroupCollector<T, T> createGroupCollector() {
        return new GroupCollector<T, T>(){
            private BigDecimal sum = BigDecimal.ZERO;

            @Override
            public void add(T t) {
                this.sum = this.sum.add(new BigDecimal(t.toString()));
            }

            @Override
            public T get() {
                return MathUtils.cast(this.sum, GSum.this.getType());
            }
        };
    }
}

