/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.CaseForEqBuilder;
import com.mysema.query.types.expr.DslExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public abstract class SimpleExpression<T>
extends DslExpression<T> {
    private static final long serialVersionUID = -4405387187738167105L;
    @Nullable
    private volatile NumberExpression<Long> count;
    @Nullable
    private volatile NumberExpression<Long> countDistinct;
    @Nullable
    private volatile BooleanExpression isnull;
    @Nullable
    private volatile BooleanExpression isnotnull;

    public SimpleExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public SimpleExpression<T> as(Path<T> alias) {
        return SimpleOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public SimpleExpression<T> as(String alias) {
        return this.as((Path)new PathImpl(this.getType(), alias));
    }

    public BooleanExpression isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = BooleanOperation.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    public BooleanExpression isNull() {
        if (this.isnull == null) {
            this.isnull = BooleanOperation.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    public NumberExpression<Long> count() {
        if (this.count == null) {
            this.count = NumberOperation.create(Long.class, Ops.AggOps.COUNT_AGG, this);
        }
        return this.count;
    }

    public NumberExpression<Long> countDistinct() {
        if (this.countDistinct == null) {
            this.countDistinct = NumberOperation.create(Long.class, Ops.AggOps.COUNT_DISTINCT_AGG, this);
        }
        return this.countDistinct;
    }

    public BooleanExpression eq(T right) {
        if (right == null) {
            throw new IllegalArgumentException("eq(null) is not allowed. Use isNull() instead");
        }
        return this.eq((Expression<? super T>)new ConstantImpl<T>(right));
    }

    public BooleanExpression eq(Expression<? super T> right) {
        return BooleanOperation.create(Ops.EQ, this, right);
    }

    public BooleanExpression eqAll(CollectionExpression<?, ? super T> right) {
        return this.eq(ExpressionUtils.all(right));
    }

    public BooleanExpression eqAny(CollectionExpression<?, ? super T> right) {
        return this.eq(ExpressionUtils.any(right));
    }

    public BooleanExpression in(Collection<? extends T> right) {
        if (right.size() == 1) {
            return this.eq(right.iterator().next());
        }
        return BooleanOperation.create(Ops.IN, this, new ConstantImpl<Collection<? extends T>>(right));
    }

    public BooleanExpression in(T ... right) {
        if (right.length == 1) {
            return this.eq(right[0]);
        }
        return BooleanOperation.create(Ops.IN, this, new ConstantImpl<List<T>>(Arrays.asList(right)));
    }

    public BooleanExpression in(CollectionExpression<?, ? extends T> right) {
        return BooleanOperation.create(Ops.IN, this, right);
    }

    public BooleanExpression ne(T right) {
        return this.ne((Expression<? super T>)new ConstantImpl<T>(right));
    }

    public BooleanExpression ne(Expression<? super T> right) {
        return BooleanOperation.create(Ops.NE, this, right);
    }

    public BooleanExpression neAll(CollectionExpression<?, ? super T> right) {
        return this.ne(ExpressionUtils.all(right));
    }

    public BooleanExpression neAny(CollectionExpression<?, ? super T> right) {
        return this.ne(ExpressionUtils.any(right));
    }

    public BooleanExpression notIn(Collection<? extends T> right) {
        if (right.size() == 1) {
            return this.ne(right.iterator().next());
        }
        return this.in(right).not();
    }

    public BooleanExpression notIn(T ... right) {
        if (right.length == 1) {
            return this.ne(right[0]);
        }
        return this.in(right).not();
    }

    public final BooleanExpression notIn(CollectionExpression<?, ? extends T> right) {
        return this.in(right).not();
    }

    public CaseForEqBuilder<T> when(T other) {
        return new CaseForEqBuilder<T>(this, new ConstantImpl<T>(other));
    }

    public CaseForEqBuilder<T> when(Expression<? extends T> other) {
        return new CaseForEqBuilder<T>(this, other);
    }
}

