/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class Templates {
    public static final Templates DEFAULT = new Templates();
    private final Map<Operator<?>, Template> templates = new HashMap();
    private final Map<Operator<?>, Integer> precedence = new HashMap();
    private final TemplateFactory templateFactory;

    protected Templates() {
        this('\\');
    }

    protected Templates(char escape) {
        this.templateFactory = new TemplateFactory(escape);
        this.add(Ops.LIST, "{0}, {1}");
        this.add(Ops.WRAPPED, "({0})");
        this.add(Ops.AND, "{0} && {1}", 36);
        this.add(Ops.NOT, "!{0}", 3);
        this.add(Ops.OR, "{0} || {1}", 38);
        this.add(Ops.XNOR, "{0} xnor {1}", 39);
        this.add(Ops.XOR, "{0} xor {1}", 39);
        this.add(Ops.COL_IS_EMPTY, "empty({0})");
        this.add(Ops.COL_SIZE, "size({0})");
        this.add(Ops.ARRAY_SIZE, "size({0})");
        this.add(Ops.MAP_SIZE, "size({0})");
        this.add(Ops.MAP_IS_EMPTY, "empty({0})");
        this.add(Ops.CONTAINS_KEY, "containsKey({0},{1})");
        this.add(Ops.CONTAINS_VALUE, "containsValue({0},{1})");
        this.add(Ops.BETWEEN, "{0} between {1} and {2}", 30);
        this.add(Ops.GOE, "{0} >= {1}", 20);
        this.add(Ops.GT, "{0} > {1}", 21);
        this.add(Ops.LOE, "{0} <= {1}", 22);
        this.add(Ops.LT, "{0} < {1}", 23);
        this.add(Ops.NEGATE, "-{0}", 6);
        this.add(Ops.ADD, "{0} + {1}", 13);
        this.add(Ops.DIV, "{0} / {1}", 8);
        this.add(Ops.MOD, "{0} % {1}", 10);
        this.add(Ops.MULT, "{0} * {1}", 7);
        this.add(Ops.SUB, "{0} - {1}", 12);
        this.add(Ops.EQ, "{0} = {1}", 18);
        this.add(Ops.EQ_IGNORE_CASE, "eqIc({0},{1})", 18);
        this.add(Ops.INSTANCE_OF, "{0}.class = {1}");
        this.add(Ops.NE, "{0} != {1}", 25);
        this.add(Ops.IN, "{0} in {1}");
        this.add(Ops.IS_NULL, "{0} is null", 26);
        this.add(Ops.IS_NOT_NULL, "{0} is not null", 26);
        this.add(Ops.ALIAS, "{0} as {1}");
        this.add(Ops.EXISTS, "exists({0})");
        this.add(Ops.NUMCAST, "cast({0},{1})");
        this.add(Ops.STRING_CAST, "str({0})");
        this.add(Ops.CONCAT, "{0} + {1}", 37);
        this.add(Ops.LOWER, "lower({0})");
        this.add(Ops.SUBSTR_1ARG, "substring({0},{1})");
        this.add(Ops.SUBSTR_2ARGS, "substring({0},{1},{2})");
        this.add(Ops.TRIM, "trim({0})");
        this.add(Ops.UPPER, "upper({0})");
        this.add(Ops.MATCHES, "matches({0},{1})");
        this.add(Ops.MATCHES_IC, "matchesIgnoreCase({0},{1})");
        this.add(Ops.STARTS_WITH, "startsWith({0},{1})");
        this.add(Ops.STARTS_WITH_IC, "startsWithIgnoreCase({0},{1})");
        this.add(Ops.ENDS_WITH, "endsWith({0},{1})");
        this.add(Ops.ENDS_WITH_IC, "endsWithIgnoreCase({0},{1})");
        this.add(Ops.STRING_CONTAINS, "contains({0},{1})");
        this.add(Ops.STRING_CONTAINS_IC, "containsIc({0},{1})");
        this.add(Ops.CHAR_AT, "charAt({0},{1})");
        this.add(Ops.STRING_LENGTH, "length({0})");
        this.add(Ops.INDEX_OF, "indexOf({0},{1})");
        this.add(Ops.INDEX_OF_2ARGS, "indexOf({0},{1},{2})");
        this.add(Ops.STRING_IS_EMPTY, "empty({0})");
        this.add(Ops.LIKE, "{0} like {1}");
        this.add(Ops.LIKE_ESCAPE, "{0} like {1} escape '{2s}'");
        this.add(Ops.StringOps.LTRIM, "ltrim({0})");
        this.add(Ops.StringOps.RTRIM, "rtrim({0})");
        this.add(Ops.StringOps.LOCATE, "locate({0},{1})");
        this.add(Ops.StringOps.LOCATE2, "locate({0},{1},{2s})");
        this.add(Ops.StringOps.LPAD, "lpad({0},{1})");
        this.add(Ops.StringOps.RPAD, "rpad({0},{1})");
        this.add(Ops.StringOps.LPAD2, "lpad({0},{1},'{2s}')");
        this.add(Ops.StringOps.RPAD2, "rpad({0},{1},'{2s}')");
        this.add(Ops.DateTimeOps.SYSDATE, "sysdate");
        this.add(Ops.DateTimeOps.CURRENT_DATE, "current_date()");
        this.add(Ops.DateTimeOps.CURRENT_TIME, "current_time()");
        this.add(Ops.DateTimeOps.CURRENT_TIMESTAMP, "current_timestamp()");
        this.add(Ops.DateTimeOps.SECOND, "second({0})");
        this.add(Ops.DateTimeOps.MILLISECOND, "millisecond({0})");
        this.add(Ops.DateTimeOps.MINUTE, "minute({0})");
        this.add(Ops.DateTimeOps.HOUR, "hour({0})");
        this.add(Ops.DateTimeOps.WEEK, "week({0})");
        this.add(Ops.DateTimeOps.MONTH, "month({0})");
        this.add(Ops.DateTimeOps.YEAR, "year({0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "yearMonth({0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "dayofweek({0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "dayofmonth({0})");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "dayofyear({0})");
        this.add(Ops.MathOps.ABS, "abs({0})");
        this.add(Ops.MathOps.ACOS, "acos({0})");
        this.add(Ops.MathOps.ASIN, "asin({0})");
        this.add(Ops.MathOps.ATAN, "atan({0})");
        this.add(Ops.MathOps.CEIL, "ceil({0})");
        this.add(Ops.MathOps.COS, "cos({0})");
        this.add(Ops.MathOps.COSH, "cosh({0})");
        this.add(Ops.MathOps.COT, "cot({0})");
        this.add(Ops.MathOps.COTH, "coth({0})");
        this.add(Ops.MathOps.DEG, "degrees({0})");
        this.add(Ops.MathOps.TAN, "tan({0})");
        this.add(Ops.MathOps.TANH, "tanh({0})");
        this.add(Ops.MathOps.SQRT, "sqrt({0})");
        this.add(Ops.MathOps.SIGN, "sign({0})");
        this.add(Ops.MathOps.SIN, "sin({0})");
        this.add(Ops.MathOps.SINH, "sinh({0})");
        this.add(Ops.MathOps.ROUND, "round({0})");
        this.add(Ops.MathOps.RAD, "radians({0})");
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.POWER, "pow({0},{1})");
        this.add(Ops.MathOps.MIN, "min({0},{1})");
        this.add(Ops.MathOps.MAX, "max({0},{1})");
        this.add(Ops.MathOps.LOG, "log({0},{1})");
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.FLOOR, "floor({0})");
        this.add(Ops.MathOps.EXP, "exp({0})");
        this.add(PathType.PROPERTY, "{0}.{1s}");
        this.add(PathType.VARIABLE, "{0s}");
        this.add(Ops.ORDINAL, "ordinal({0})");
        this.add(Ops.DELEGATE, "{0}");
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.MAPVALUE_CONSTANT}) {
            this.add(type, "{0}.get({1})");
        }
        this.add(PathType.ARRAYVALUE, "{0}[{1}]");
        this.add(PathType.COLLECTION_ANY, "any({0})");
        this.add(PathType.LISTVALUE_CONSTANT, "{0}.get({1s})");
        this.add(PathType.ARRAYVALUE_CONSTANT, "{0}[{1s}]");
        this.add(Ops.CASE, "case {0} end");
        this.add(Ops.CASE_WHEN, "when {0} then {1} {2}");
        this.add(Ops.CASE_ELSE, "else {0}");
        this.add(Ops.CASE_EQ, "case {0} {1} end");
        this.add(Ops.CASE_EQ_WHEN, "when {1} then {2} {3}");
        this.add(Ops.CASE_EQ_ELSE, "else {0}");
        this.add(Ops.COALESCE, "coalesce({0})");
        this.add(Ops.EXISTS, "exists {0}");
        this.add(Ops.AggOps.AVG_AGG, "avg({0})");
        this.add(Ops.AggOps.MAX_AGG, "max({0})");
        this.add(Ops.AggOps.MIN_AGG, "min({0})");
        this.add(Ops.AggOps.SUM_AGG, "sum({0})");
        this.add(Ops.AggOps.COUNT_AGG, "count({0})");
        this.add(Ops.AggOps.COUNT_DISTINCT_AGG, "count(distinct {0})");
        this.add(Ops.AggOps.COUNT_ALL_AGG, "count(*)");
        this.add(Ops.QuantOps.AVG_IN_COL, "avg({0})");
        this.add(Ops.QuantOps.MAX_IN_COL, "max({0})");
        this.add(Ops.QuantOps.MIN_IN_COL, "min({0})");
        this.add(Ops.QuantOps.ANY, "any {0}");
        this.add(Ops.QuantOps.ALL, "all {0}");
    }

    protected final void add(Operator<?> op, String pattern) {
        Template template = this.templateFactory.create(pattern);
        this.templates.put(op, template);
    }

    protected final void add(Operator<?> op, String pattern, int pre) {
        this.add(op, pattern);
        this.precedence.put(op, pre);
    }

    @Nullable
    public Template getTemplate(Operator<?> op) {
        return this.templates.get(op);
    }

    public int getPrecedence(Operator<?> operator) {
        if (this.precedence.containsKey(operator)) {
            return this.precedence.get(operator);
        }
        return -1;
    }
}

