/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.support.CollectionAnyVisitor;
import com.mysema.query.support.Context;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.ProjectionRole;
import com.mysema.query.types.SubQueryExpression;
import java.util.Collection;

public class QueryMixin<T> {
    private final QueryMetadata metadata;
    private T self;

    public QueryMixin() {
        this.metadata = new DefaultQueryMetadata();
    }

    public QueryMixin(QueryMetadata metadata) {
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public QueryMixin(T self) {
        this(self, new DefaultQueryMetadata());
    }

    public QueryMixin(T self, QueryMetadata metadata) {
        this.self = Assert.notNull(self, (String)"self");
        this.metadata = (QueryMetadata)Assert.notNull((Object)metadata, (String)"metadata");
    }

    public T addFlag(QueryFlag queryFlag) {
        this.metadata.addFlag(queryFlag);
        return this.self;
    }

    public T addToProjection(Expression<?> ... o) {
        this.metadata.addProjection(this.convert(o));
        return this.self;
    }

    private <P extends Path<?>> P assertRoot(P p) {
        if (!p.getRoot().equals(p)) {
            throw new IllegalArgumentException(p + " is not a root path");
        }
        return p;
    }

    public <RT> Expression<RT> convert(Expression<RT> expr) {
        Context context;
        Expression replaced;
        if (expr instanceof Path && !(replaced = (Expression)expr.accept(CollectionAnyVisitor.DEFAULT, context = new Context())).equals(expr)) {
            for (int i = 0; i < context.paths.size(); ++i) {
                Path<?> path = context.paths.get(i).getMetadata().getParent();
                Path replacement = context.replacements.get(i);
                this.innerJoin(path, replacement);
            }
            return replaced;
        }
        if (expr instanceof ProjectionRole) {
            return this.convert(((ProjectionRole)expr).getProjection());
        }
        if (expr instanceof FactoryExpression && !(expr instanceof FactoryExpressionUtils.FactoryExpressionAdapter)) {
            return FactoryExpressionUtils.wrap((FactoryExpression)expr);
        }
        return expr;
    }

    public final Expression<?>[] convert(Expression<?>[] exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.convert(exprs[i]);
        }
        return exprs;
    }

    protected <D> Expression<D> createAlias(Expression<D> path, Path<D> alias) {
        this.assertRoot(alias);
        return ExpressionUtils.as(path, alias);
    }

    protected <D> Expression<D> createAlias(Path<? extends Collection<D>> target, Path<D> alias) {
        this.assertRoot(alias);
        return OperationImpl.create(alias.getType(), Ops.ALIAS, target, alias);
    }

    protected <D> Expression<D> createAlias(MapExpression<?, D> target, Path<D> alias) {
        this.assertRoot(alias);
        return OperationImpl.create(alias.getType(), Ops.ALIAS, target, alias);
    }

    protected <D> Expression<D> createAlias(SubQueryExpression<D> path, Path<D> alias) {
        this.assertRoot(alias);
        return ExpressionUtils.as(path, alias);
    }

    public T distinct() {
        this.metadata.setDistinct(true);
        return this.self;
    }

    public T from(Expression<?> ... args) {
        for (Expression<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public T from(EntityPath<?> ... args) {
        for (EntityPath<?> arg : args) {
            this.metadata.addJoin(JoinType.DEFAULT, arg);
        }
        return this.self;
    }

    public <P> T fullJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias((Expression)target, (Path)alias));
        return this.self;
    }

    public <P> T fullJoin(Path<? extends Collection<P>> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T fullJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.FULLJOIN, target);
        return this.self;
    }

    public <P> T fullJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T fullJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.FULLJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public QueryMetadata getMetadata() {
        return this.metadata;
    }

    public T getSelf() {
        return this.self;
    }

    public T groupBy(Expression<?> ... o) {
        this.metadata.addGroupBy(o);
        return this.self;
    }

    public T having(Predicate ... o) {
        this.metadata.addHaving(this.normalize(o, false));
        return this.self;
    }

    public <P> T innerJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias((Expression)target, (Path)alias));
        return this.self;
    }

    public <P> T innerJoin(Path<? extends Collection<P>> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T innerJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.INNERJOIN, target);
        return this.self;
    }

    public <P> T innerJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T innerJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.INNERJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public boolean isDistinct() {
        return this.metadata.isDistinct();
    }

    public boolean isUnique() {
        return this.metadata.isUnique();
    }

    public <P> T join(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.self;
    }

    public <P> T join(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias((Expression)target, (Path)alias));
        return this.getSelf();
    }

    public <P> T join(Path<? extends Collection<P>> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.getSelf();
    }

    public <P> T join(Path<? extends Collection<P>> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T join(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.JOIN, target);
        return this.getSelf();
    }

    public <P> T join(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T join(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.JOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T leftJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.self;
    }

    public <P> T leftJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias((Expression)target, (Path)alias));
        return this.getSelf();
    }

    public <P> T leftJoin(Path<? extends Collection<P>> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.getSelf();
    }

    public <P> T leftJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T leftJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.LEFTJOIN, target);
        return this.getSelf();
    }

    public <P> T leftJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T leftJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.LEFTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public T limit(long limit) {
        this.metadata.setLimit(limit);
        return this.self;
    }

    public T offset(long offset) {
        this.metadata.setOffset(offset);
        return this.self;
    }

    public T on(Predicate ... conditions) {
        for (Predicate condition : conditions) {
            this.metadata.addJoinCondition(condition);
        }
        return this.self;
    }

    public T orderBy(OrderSpecifier<?> ... o) {
        this.metadata.addOrderBy(o);
        return this.self;
    }

    public T restrict(QueryModifiers modifiers) {
        this.metadata.setModifiers(modifiers);
        return this.self;
    }

    public <P> T rightJoin(EntityPath<P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.self;
    }

    public <P> T rightJoin(EntityPath<P> target, EntityPath<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias((Expression)target, (Path)alias));
        return this.getSelf();
    }

    public <P> T rightJoin(Path<? extends Collection<P>> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.getSelf();
    }

    public <P> T rightJoin(Path<? extends Collection<P>> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T rightJoin(MapExpression<?, P> target) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, target);
        return this.getSelf();
    }

    public <P> T rightJoin(MapExpression<?, P> target, Path<P> alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.getSelf();
    }

    public <P> T rightJoin(SubQueryExpression<P> target, Path alias) {
        this.metadata.addJoin(JoinType.RIGHTJOIN, this.createAlias(target, alias));
        return this.self;
    }

    public <P> T set(ParamExpression<P> param, P value) {
        this.metadata.setParam(param, value);
        return this.self;
    }

    public void setDistinct(boolean distinct) {
        this.metadata.setDistinct(distinct);
    }

    public void setSelf(T self) {
        this.self = self;
    }

    public void setUnique(boolean unique) {
        this.metadata.setUnique(unique);
    }

    public T where(Predicate ... o) {
        this.metadata.addWhere(this.normalize(o, true));
        return this.self;
    }

    protected Predicate normalize(Predicate condition, boolean where) {
        return condition;
    }

    protected final Predicate[] normalize(Predicate[] conditions, boolean where) {
        for (int i = 0; i < conditions.length; ++i) {
            if (conditions[i] == null) continue;
            conditions[i] = this.normalize(conditions[i], where);
        }
        return conditions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryMixin) {
            QueryMixin q = (QueryMixin)o;
            return q.metadata.equals(this.metadata);
        }
        return false;
    }

    public int hashCode() {
        return this.metadata.hashCode();
    }

    public String toString() {
        return this.metadata.toString();
    }

    private static String uncapitalize(String str) {
        if (str.length() > 1) {
            return Character.toLowerCase(str.charAt(0)) + str.substring(1);
        }
        return str.toLowerCase();
    }
}

