/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Visitor;
import com.mysema.util.ReflectionUtils;
import java.lang.reflect.AnnotatedElement;
import javax.annotation.Nullable;

public class PathImpl<T>
extends ExpressionBase<T>
implements Path<T> {
    private static final long serialVersionUID = -2498447742798348162L;
    private final PathMetadata<?> metadata;
    private final Path<?> root;
    @Nullable
    private AnnotatedElement annotatedElement;

    public PathImpl(Class<? extends T> type, String variable) {
        this(type, PathMetadataFactory.forVariable(variable));
    }

    public PathImpl(Class<? extends T> type, PathMetadata<?> metadata) {
        super(type);
        this.metadata = (PathMetadata)Assert.notNull(metadata, (String)"metadata");
        this.root = metadata.getRoot() != null ? metadata.getRoot() : this;
    }

    public PathImpl(Class<? extends T> type, Path<?> parent, String property) {
        this(type, PathMetadataFactory.forProperty(parent, property));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Path) {
            return ((Path)o).getMetadata().equals(this.metadata);
        }
        return false;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.metadata;
    }

    @Override
    public Path<?> getRoot() {
        return this.root;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        if (this.annotatedElement == null) {
            if (this.metadata.getPathType() == PathType.PROPERTY) {
                Class beanClass = this.metadata.getParent().getType();
                String propertyName = this.metadata.getExpression().toString();
                this.annotatedElement = ReflectionUtils.getAnnotatedElement(beanClass, propertyName, this.getType());
            } else {
                this.annotatedElement = this.getType();
            }
        }
        return this.annotatedElement;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }
}

