/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QTuple
extends ExpressionBase<Tuple>
implements FactoryExpression<Tuple> {
    private static final long serialVersionUID = -2640616030595420465L;
    private final List<Expression<?>> args;

    public QTuple(Expression<?> ... args) {
        super(Tuple.class);
        this.args = Arrays.asList(args);
    }

    public QTuple(Expression<?>[] ... args) {
        super(Tuple.class);
        this.args = new ArrayList();
        for (Expression<?>[] exprs : args) {
            this.args.addAll(Arrays.asList(exprs));
        }
    }

    @Override
    public Tuple newInstance(final Object ... a) {
        return new Tuple(){

            @Override
            public <T> T get(int index, Class<T> type) {
                return (T)a[index];
            }

            @Override
            public <T> T get(Expression<T> expr) {
                int index = QTuple.this.args.indexOf(expr);
                return (T)(index != -1 ? a[index] : null);
            }

            @Override
            public Object[] toArray() {
                return a;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Tuple) {
                    return Arrays.equals(a, ((Tuple)obj).toArray());
                }
                return false;
            }

            @Override
            public int hashCode() {
                return Arrays.hashCode(a);
            }
        };
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QTuple) {
            QTuple c = (QTuple)obj;
            return ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }
}

