/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.PredicateOperation;
import com.mysema.query.types.TemplateExpressionImpl;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class ExpressionUtils {
    @Nullable
    public static Predicate allOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate allOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    public static Predicate and(Predicate left, Predicate right) {
        return new PredicateOperation(Ops.AND, left, right);
    }

    @Nullable
    public static Predicate anyOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate anyOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    public static <D> Expression<D> as(Expression<D> source, Path<D> alias) {
        return new OperationImpl<Object>(alias.getType(), Ops.ALIAS, source, alias);
    }

    public static <D> Expression<D> as(Expression<D> source, String alias) {
        return ExpressionUtils.as(source, new PathImpl<D>(source.getType(), alias));
    }

    public static Expression<Long> count(Expression<?> source) {
        return OperationImpl.create(Long.class, Ops.AggOps.COUNT_AGG, source);
    }

    public static <D> Predicate eqConst(Expression<D> left, D constant) {
        return ExpressionUtils.eq(left, new ConstantImpl<D>(constant));
    }

    public static <D> Predicate eq(Expression<D> left, Expression<? extends D> right) {
        if (ExpressionUtils.isPrimitive(left.getType())) {
            return new PredicateOperation(Ops.EQ_PRIMITIVE, left, right);
        }
        return new PredicateOperation(Ops.EQ_OBJECT, left, right);
    }

    public static <D> Predicate in(Expression<D> left, CollectionExpression<?, ? extends D> right) {
        return new PredicateOperation(Ops.IN, left, right);
    }

    public static <D> Predicate in(Expression<D> left, Collection<? extends D> right) {
        if (right.size() == 1) {
            return ExpressionUtils.eqConst(left, right.iterator().next());
        }
        return new PredicateOperation(Ops.IN, left, new ConstantImpl<Collection<? extends D>>(right));
    }

    public static Predicate isNull(Expression<?> left) {
        return new PredicateOperation(Ops.IS_NULL, left);
    }

    public static Predicate isNotNull(Expression<?> left) {
        return new PredicateOperation(Ops.IS_NOT_NULL, left);
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    public static Expression<String> likeToRegex(Expression<String> expr) {
        if (expr instanceof Constant) {
            return ConstantImpl.create(expr.toString().replace("%", ".*").replace("_", "."));
        }
        if (expr instanceof Operation) {
            Operation o = (Operation)expr;
            if (o.getOperator() == Ops.CONCAT) {
                Expression<String> lhs = ExpressionUtils.likeToRegex(o.getArg(0));
                Expression<String> rhs = ExpressionUtils.likeToRegex(o.getArg(1));
                return new OperationImpl<String>(String.class, Ops.CONCAT, lhs, rhs);
            }
            return expr;
        }
        return expr;
    }

    public static Expression<?> merge(List<? extends Expression<?>> expressions) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < expressions.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("{" + i + "}");
        }
        return TemplateExpressionImpl.create(Object.class, builder.toString(), expressions.toArray(new Expression[expressions.size()]));
    }

    public static Expression<String> regexToLike(Expression<String> expr) {
        if (expr instanceof Constant) {
            return ConstantImpl.create(expr.toString().replace(".*", "%").replace(".", "_"));
        }
        if (expr instanceof Operation) {
            Operation o = (Operation)expr;
            if (o.getOperator() == Ops.CONCAT) {
                Expression<String> lhs = ExpressionUtils.regexToLike(o.getArg(0));
                Expression<String> rhs = ExpressionUtils.regexToLike(o.getArg(1));
                return new OperationImpl<String>(String.class, Ops.CONCAT, lhs, rhs);
            }
            return expr;
        }
        return expr;
    }

    public static <D> Predicate neConst(Expression<D> left, D constant) {
        return ExpressionUtils.ne(left, new ConstantImpl<D>(constant));
    }

    public static <D> Predicate ne(Expression<D> left, Expression<? super D> right) {
        if (ExpressionUtils.isPrimitive(left.getType())) {
            return new PredicateOperation(Ops.NE_PRIMITIVE, left, right);
        }
        return new PredicateOperation(Ops.NE_OBJECT, left, right);
    }

    public static Predicate or(Predicate left, Predicate right) {
        return new PredicateOperation(Ops.OR, left, right);
    }

    private ExpressionUtils() {
    }
}

