/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.expr.TimeOperation;
import java.util.ArrayList;
import java.util.List;

public class Coalesce<T extends Comparable>
extends ComparableExpression<T> {
    private static final long serialVersionUID = 445439522266250417L;
    private final List<Expression<? extends T>> exprs = new ArrayList<Expression<? extends T>>();

    public Coalesce(Class<? extends T> type, Expression ... exprs) {
        super(type);
        for (Expression expr : exprs) {
            this.add((T)expr);
        }
    }

    public Coalesce(Expression ... exprs) {
        this(exprs.length > 0 ? exprs[0].getType() : Object.class, exprs);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return SimpleOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList()).accept(v, context);
    }

    public final Coalesce<T> add(Expression<T> expr) {
        this.exprs.add(expr);
        return this;
    }

    public final Coalesce<T> add(T constant) {
        this.exprs.add(new ConstantImpl<T>(constant));
        return this;
    }

    public DateExpression<T> asDate() {
        return DateOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public DateTimeExpression<T> asDateTime() {
        return DateTimeOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public NumberExpression<?> asNumber() {
        return NumberOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    public StringExpression asString() {
        return StringOperation.create(Ops.COALESCE, this.getExpressionList());
    }

    public TimeExpression<T> asTime() {
        return TimeOperation.create(this.getType(), Ops.COALESCE, this.getExpressionList());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Coalesce) {
            Coalesce c = (Coalesce)o;
            return ((Object)c.exprs).equals(this.exprs);
        }
        return false;
    }

    private Expression<?> getExpressionList() {
        Expression<? extends T> arg = this.exprs.get(0);
        for (int i = 1; i < this.exprs.size(); ++i) {
            arg = SimpleOperation.create(List.class, Ops.LIST, arg, this.exprs.get(i));
        }
        return arg;
    }

    @Override
    public int hashCode() {
        return ((Object)this.exprs).hashCode();
    }
}

