/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.Assert;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class SerializerBase<S extends SerializerBase<S>>
implements Visitor<Void, Void> {
    private final StringBuilder builder = new StringBuilder();
    private String constantPrefix = "a";
    private String paramPrefix = "p";
    private String anonParamPrefix = "_";
    private final Map<Object, String> constantToLabel = new HashMap<Object, String>();
    private final S self = this;
    private final Templates templates;
    private final boolean dry;

    public SerializerBase(Templates templates) {
        this(templates, false);
    }

    public SerializerBase(Templates templates, boolean dry) {
        this.templates = (Templates)Assert.notNull((Object)templates, (String)"templates");
        this.dry = dry;
    }

    public S prepend(String ... str) {
        if (!this.dry) {
            this.builder.insert(0, StringUtils.join((Object[])str));
        }
        return this.self;
    }

    public S append(String ... str) {
        if (!this.dry) {
            for (String s : str) {
                this.builder.append(s);
            }
        }
        return this.self;
    }

    protected String getConstantPrefix() {
        return this.constantPrefix;
    }

    public Map<Object, String> getConstantToLabel() {
        return this.constantToLabel;
    }

    protected Template getTemplate(Operator<?> op) {
        return this.templates.getTemplate(op);
    }

    public S handle(Expression<?> expr) {
        expr.accept(this, null);
        return this.self;
    }

    public S handle(JoinFlag joinFlag) {
        return this.handle(joinFlag.getFlag());
    }

    public final S handle(String sep, List<?> expressions) {
        boolean first = true;
        for (Object expr : expressions) {
            if (!first) {
                this.append(sep);
            }
            if (!(expr instanceof Expression)) {
                throw new IllegalArgumentException("Unsupported type " + expr.getClass().getName());
            }
            this.handle((Expression)expr);
            first = false;
        }
        return this.self;
    }

    private void handleTemplate(Template template, List<Expression<?>> args) {
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            if (element.isAsString()) {
                this.appendAsString(args.get(element.getIndex()));
                continue;
            }
            if (element.hasConverter()) {
                this.handle(element.convert(args.get(element.getIndex())));
                continue;
            }
            this.handle(args.get(element.getIndex()));
        }
    }

    protected boolean serialize(QueryFlag.Position position, Set<QueryFlag> flags) {
        boolean handled = false;
        for (QueryFlag flag : flags) {
            if (flag.getPosition() != position) continue;
            this.handle(flag.getFlag());
            handled = true;
        }
        return handled;
    }

    protected boolean serialize(JoinFlag.Position position, Set<JoinFlag> flags) {
        boolean handled = false;
        for (JoinFlag flag : flags) {
            if (flag.getPosition() != position) continue;
            this.handle(flag.getFlag());
            handled = true;
        }
        return handled;
    }

    public void setConstantPrefix(String prefix) {
        this.constantPrefix = prefix;
    }

    public void setParamPrefix(String prefix) {
        this.paramPrefix = prefix;
    }

    public void setAnonParamPrefix(String prefix) {
        this.anonParamPrefix = prefix;
    }

    public String toString() {
        return this.builder.toString();
    }

    @Override
    public Void visit(Constant<?> expr, Void context) {
        if (!this.getConstantToLabel().containsKey(expr.getConstant())) {
            String constLabel = this.constantPrefix + (this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(expr.getConstant(), constLabel);
            this.append(constLabel);
        } else {
            this.append(this.getConstantToLabel().get(expr.getConstant()));
        }
        return null;
    }

    @Override
    public Void visit(ParamExpression<?> param, Void context) {
        String paramLabel = param.isAnon() ? this.anonParamPrefix + param.getName() : this.paramPrefix + param.getName();
        this.getConstantToLabel().put(param, paramLabel);
        this.append(paramLabel);
        return null;
    }

    @Override
    public Void visit(TemplateExpression<?> expr, Void context) {
        this.handleTemplate(expr.getTemplate(), expr.getArgs());
        return null;
    }

    @Override
    public Void visit(FactoryExpression<?> expr, Void context) {
        this.handle(", ", expr.getArgs());
        return null;
    }

    @Override
    public Void visit(Operation<?> expr, Void context) {
        this.visitOperation(expr.getType(), expr.getOperator(), expr.getArgs());
        return null;
    }

    @Override
    public Void visit(Path<?> path, Void context) {
        PathType pathType = path.getMetadata().getPathType();
        Template template = this.templates.getTemplate(pathType);
        ArrayList args = new ArrayList();
        if (path.getMetadata().getParent() != null) {
            args.add(path.getMetadata().getParent());
        }
        args.add(path.getMetadata().getExpression());
        this.handleTemplate(template, args);
        return null;
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        Template template = this.templates.getTemplate(operator);
        if (template == null) {
            throw new IllegalArgumentException("Got no pattern for " + operator);
        }
        int precedence = this.templates.getPrecedence(operator);
        for (Template.Element element : template.getElements()) {
            if (element.getStaticText() != null) {
                this.append(element.getStaticText());
                continue;
            }
            if (element.isAsString()) {
                this.appendAsString(args.get(element.getIndex()));
                continue;
            }
            int i = element.getIndex();
            boolean wrap = false;
            Expression<?> arg = args.get(i);
            if (arg instanceof Operation && ((Operation)arg).getOperator() == Ops.DELEGATE) {
                arg = ((Operation)arg).getArg(0);
            }
            if (arg instanceof Operation) {
                boolean bl = wrap = precedence < this.templates.getPrecedence(((Operation)arg).getOperator());
            }
            if (wrap) {
                this.append("(");
            }
            if (element.hasConverter()) {
                this.handle(element.convert(arg));
            } else {
                this.handle(arg);
            }
            if (!wrap) continue;
            this.append(")");
        }
    }

    protected void appendAsString(Expression<?> expr) {
        this.append(expr.toString());
    }
}

