/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class OrderedQueryMetadata
extends DefaultQueryMetadata {
    private static final long serialVersionUID = 6326236143414219377L;
    private final List<JoinExpression> joins = new ArrayList<JoinExpression>();
    @Nullable
    private JoinExpression last;

    public OrderedQueryMetadata() {
        super(false);
    }

    @Override
    public void addJoin(JoinExpression ... j) {
        for (JoinExpression join : j) {
            if (this.joins.contains(join)) continue;
            if (join.getType() == JoinType.DEFAULT) {
                int index;
                for (index = this.joins.size(); index > 0 && this.joins.get(index - 1).getType() != JoinType.DEFAULT; --index) {
                }
                this.joins.add(index, join);
            } else {
                this.joins.add(join);
            }
            this.last = join;
        }
    }

    @Override
    public void addJoin(JoinType joinType, Expression<?> expr) {
        this.addJoin(new JoinExpression(joinType, expr));
    }

    @Override
    public void addJoinCondition(Predicate o) {
        if (this.last != null) {
            this.last.addCondition(o);
        }
    }

    @Override
    public QueryMetadata clone() {
        QueryMetadata md = super.clone();
        for (JoinExpression join : this.joins) {
            md.addJoin(join);
        }
        return md;
    }

    @Override
    public List<JoinExpression> getJoins() {
        return this.joins;
    }
}

