/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.util.BeanUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanSerializer
implements Serializer {
    private final boolean propertyAnnotations;
    private final String javadocSuffix;

    public BeanSerializer() {
        this(true, " is a Querydsl bean type");
    }

    public BeanSerializer(String javadocSuffix) {
        this(true, javadocSuffix);
    }

    public BeanSerializer(boolean propertyAnnotations) {
        this(propertyAnnotations, " is a Querydsl bean type");
    }

    public BeanSerializer(boolean propertyAnnotations, String javadocSuffix) {
        this.propertyAnnotations = propertyAnnotations;
        this.javadocSuffix = javadocSuffix;
    }

    @Override
    public void serialize(EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        if (!model.getPackageName().isEmpty()) {
            writer.packageDecl(model.getPackageName());
        }
        Set<String> importedClasses = this.getAnnotationTypes(model);
        if (model.hasLists()) {
            importedClasses.add(List.class.getName());
        }
        if (model.hasMaps()) {
            importedClasses.add(Map.class.getName());
        }
        writer.importClasses(importedClasses.toArray(new String[importedClasses.size()]));
        writer.javadoc(new String[]{simpleName + this.javadocSuffix});
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.beginClass((Type)model);
        this.bodyStart(model, writer);
        for (Property property : model.getProperties()) {
            if (this.propertyAnnotations) {
                for (Annotation annotation : property.getAnnotations()) {
                    writer.annotation(annotation);
                }
            }
            writer.privateField(property.getType(), property.getEscapedName());
        }
        for (Property property : model.getProperties()) {
            String propertyName = property.getEscapedName();
            writer.beginPublicMethod(property.getType(), "get" + BeanUtils.capitalize(propertyName), new Parameter[0]);
            writer.line(new String[]{"return ", propertyName, ";"});
            writer.end();
            Parameter parameter = new Parameter(propertyName, property.getType());
            writer.beginPublicMethod((Type)Types.VOID, "set" + BeanUtils.capitalize(propertyName), new Parameter[]{parameter});
            writer.line(new String[]{"this.", propertyName, " = ", propertyName, ";"});
            writer.end();
        }
        this.bodyEnd(model, writer);
        writer.end();
    }

    protected void bodyStart(EntityType model, CodeWriter writer) throws IOException {
    }

    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
    }

    private Set<String> getAnnotationTypes(EntityType model) {
        HashSet<String> imports = new HashSet<String>();
        for (Annotation annotation : model.getAnnotations()) {
            imports.add(annotation.annotationType().getName());
        }
        if (this.propertyAnnotations) {
            for (Property property : model.getProperties()) {
                for (Annotation annotation : property.getAnnotations()) {
                    imports.add(annotation.annotationType().getName());
                }
            }
        }
        return imports;
    }
}

