/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.support.ClassUtils;
import com.mysema.query.QueryException;
import com.mysema.query.annotations.Config;
import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryEmbeddable;
import com.mysema.query.annotations.QueryEmbedded;
import com.mysema.query.annotations.QueryEntity;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QuerySupertype;
import com.mysema.query.annotations.QueryTransient;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.codegen.CodegenModule;
import com.mysema.query.codegen.EmbeddableSerializer;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.SimpleSerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.SupertypeSerializer;
import com.mysema.query.codegen.TypeFactory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.util.BeanUtils;
import com.mysema.util.ClassPathUtils;
import com.mysema.util.ReflectionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class GenericExporter {
    private Class<? extends Annotation> entityAnnotation = QueryEntity.class;
    private Class<? extends Annotation> supertypeAnnotation = QuerySupertype.class;
    private Class<? extends Annotation> embeddableAnnotation = QueryEmbeddable.class;
    private Class<? extends Annotation> embeddedAnnotation = QueryEmbedded.class;
    private Class<? extends Annotation> skipAnnotation = QueryTransient.class;
    private boolean createScalaSources = false;
    private final Map<String, EntityType> allTypes = new HashMap<String, EntityType>();
    private final Map<Class<?>, EntityType> entityTypes = new HashMap();
    private final Map<Class<?>, EntityType> superTypes = new HashMap();
    private final Map<Class<?>, EntityType> embeddableTypes = new HashMap();
    private final CodegenModule codegenModule = new CodegenModule();
    private final SerializerConfig serializerConfig = SimpleSerializerConfig.DEFAULT;
    @Nullable
    private File targetFolder;
    @Nullable
    private TypeFactory typeFactory;
    @Nullable
    private TypeMappings typeMappings;
    @Nullable
    private QueryTypeFactory queryTypeFactory;
    @Nullable
    private Class<? extends Serializer> serializerClass;

    public void export(Package ... packages) {
        this.scanPackages(packages);
        this.typeMappings = this.codegenModule.get(TypeMappings.class);
        this.queryTypeFactory = this.codegenModule.get(QueryTypeFactory.class);
        this.typeFactory = new TypeFactory(this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation);
        for (Class<?> cl : this.superTypes.keySet()) {
            this.createEntityType(cl, this.superTypes);
        }
        for (Class<?> cl : this.embeddableTypes.keySet()) {
            this.createEntityType(cl, this.embeddableTypes);
        }
        for (Class<?> cl : this.entityTypes.keySet()) {
            this.createEntityType(cl, this.entityTypes);
        }
        for (Map entries : Arrays.asList(this.superTypes, this.embeddableTypes, this.entityTypes)) {
            for (Map.Entry entry : entries.entrySet()) {
                this.addProperties((Class)entry.getKey(), (EntityType)entry.getValue());
            }
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        try {
            Serializer embeddableSerializer;
            Serializer entitySerializer;
            Serializer supertypeSerializer;
            if (this.serializerClass != null) {
                Serializer serializer;
                supertypeSerializer = serializer = this.codegenModule.get(this.serializerClass);
                entitySerializer = serializer;
                embeddableSerializer = serializer;
            } else {
                supertypeSerializer = this.codegenModule.get(SupertypeSerializer.class);
                entitySerializer = this.codegenModule.get(EntitySerializer.class);
                embeddableSerializer = this.codegenModule.get(EmbeddableSerializer.class);
            }
            this.serialize(supertypeSerializer, this.superTypes);
            this.serialize(entitySerializer, this.entityTypes);
            this.serialize(embeddableSerializer, this.embeddableTypes);
        }
        catch (IOException e) {
            throw new QueryException(e);
        }
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) {
                    if (supertype.getType().getPackageName().startsWith("java.")) continue;
                    try {
                        Class<?> cl = Class.forName(supertype.getType().getFullName());
                        this.typeFactory.addEmbeddableType(cl);
                        entityType = this.createEntityType(cl, new HashMap());
                        this.addProperties(cl, entityType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new QueryException(e);
                    }
                }
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private EntityType createEntityType(Class<?> cl, Map<Class<?>, EntityType> types) {
        if (types.get(cl) != null) {
            return types.get(cl);
        }
        EntityType type = this.allTypes.get(ClassUtils.getFullName(cl));
        if (type == null) {
            type = (EntityType)this.typeFactory.create(cl);
        }
        types.put(cl, type);
        this.allTypes.put(ClassUtils.getFullName(cl), type);
        this.typeMappings.register((com.mysema.codegen.model.Type)type, this.queryTypeFactory.create((com.mysema.codegen.model.Type)type));
        if (cl.getSuperclass() != null && !cl.getSuperclass().equals(Object.class)) {
            type.addSupertype(new Supertype((com.mysema.codegen.model.Type)new ClassType(cl.getSuperclass(), new com.mysema.codegen.model.Type[0])));
        }
        if (cl.isInterface()) {
            for (Class<?> iface : cl.getInterfaces()) {
                type.addSupertype(new Supertype((com.mysema.codegen.model.Type)new ClassType(iface, new com.mysema.codegen.model.Type[0])));
            }
        }
        return type;
    }

    private void addProperties(Class<?> cl, EntityType type) {
        HashSet<String> handled = new HashSet<String>();
        for (Field field : cl.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            AnnotatedElement annotated = ReflectionUtils.getAnnotatedElement(cl, field.getName(), field.getType());
            Method method = ReflectionUtils.getGetterOrNull(cl, field.getName(), field.getType());
            com.mysema.codegen.model.Type propertyType = null;
            propertyType = method != null ? this.getPropertyType(cl, annotated, method.getReturnType(), method.getGenericReturnType()) : this.getPropertyType(cl, annotated, field.getType(), field.getGenericType());
            Property property = this.createProperty(type, field.getName(), propertyType, field);
            if (property != null) {
                type.addProperty(property);
            }
            handled.add(field.getName());
        }
        for (AccessibleObject accessibleObject : cl.getDeclaredMethods()) {
            com.mysema.codegen.model.Type propertyType;
            Property property;
            String propertyName;
            if (((Method)accessibleObject).getParameterTypes().length != 0 || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is") || handled.contains(propertyName = ((Method)accessibleObject).getName().startsWith("get") ? BeanUtils.uncapitalize(((Method)accessibleObject).getName().substring(3)) : BeanUtils.uncapitalize(((Method)accessibleObject).getName().substring(2))) || (property = this.createProperty(type, propertyName, propertyType = this.getPropertyType(cl, accessibleObject, ((Method)accessibleObject).getReturnType(), ((Method)accessibleObject).getGenericReturnType()), accessibleObject)) == null) continue;
            type.addProperty(property);
        }
    }

    private com.mysema.codegen.model.Type getPropertyType(Class<?> cl, AnnotatedElement annotated, Class<?> type, Type genericType) {
        com.mysema.codegen.model.Type propertyType = (com.mysema.codegen.model.Type)this.allTypes.get(ClassUtils.getFullName(type));
        if (propertyType == null && annotated.isAnnotationPresent(this.embeddedAnnotation)) {
            Class<?> embeddableType = type;
            if (Collection.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameter(genericType, 0);
            } else if (Map.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameter(genericType, 1);
            }
            this.typeFactory.addEmbeddableType(embeddableType);
            if (!this.embeddableTypes.containsKey(embeddableType) && !this.entityTypes.containsKey(embeddableType)) {
                EntityType entityType = this.createEntityType(embeddableType, this.embeddableTypes);
                this.addProperties(embeddableType, entityType);
            }
        }
        if (propertyType == null && (propertyType = this.typeFactory.create(type, genericType)) instanceof EntityType && !this.allTypes.containsKey(ClassUtils.getFullName(type))) {
            this.allTypes.put(ClassUtils.getFullName(type), (EntityType)propertyType);
        }
        return propertyType;
    }

    @Nullable
    private Property createProperty(EntityType entityType, String propertyName, com.mysema.codegen.model.Type propertyType, AnnotatedElement annotated) {
        String[] inits = new String[]{};
        if (annotated.isAnnotationPresent(this.skipAnnotation)) {
            return null;
        }
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = annotated.getAnnotation(QueryInit.class).value();
        }
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            propertyType = propertyType.as(queryType.value().getCategory());
        }
        Property property = new Property(entityType, propertyName, propertyType, inits);
        return property;
    }

    private void scanPackages(Package ... packages) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (Package pkg : packages) {
            try {
                for (Class<?> cl : ClassPathUtils.scanPackage(classLoader, pkg)) {
                    if (cl.getAnnotation(this.embeddableAnnotation) != null) {
                        this.embeddableTypes.put(cl, null);
                        continue;
                    }
                    if (cl.getAnnotation(this.supertypeAnnotation) != null) {
                        this.superTypes.put(cl, null);
                        continue;
                    }
                    if (cl.getAnnotation(this.entityAnnotation) == null) continue;
                    this.entityTypes.put(cl, null);
                }
            }
            catch (IOException e) {
                throw new QueryException(e);
            }
        }
    }

    private void serialize(Serializer serializer, Map<Class<?>, EntityType> types) throws IOException {
        for (Map.Entry<Class<?>, EntityType> entityType : types.entrySet()) {
            com.mysema.codegen.model.Type type = this.typeMappings.getPathType((com.mysema.codegen.model.Type)entityType.getValue(), entityType.getValue(), true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
            SerializerConfig config = this.serializerConfig;
            if (entityType.getKey().isAnnotationPresent(Config.class)) {
                config = SimpleSerializerConfig.getConfig(entityType.getKey().getAnnotation(Config.class));
            }
            String fileSuffix = this.createScalaSources ? ".scala" : ".java";
            this.write(serializer, className.replace('.', '/') + fileSuffix, config, entityType.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Serializer serializer, String path, SerializerConfig serializerConfig, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        Writer w = this.writerFor(targetFile);
        try {
            ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
            serializer.serialize(type, serializerConfig, (CodeWriter)writer);
        }
        finally {
            w.close();
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            System.err.println("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setEntityAnnotation(Class<? extends Annotation> entityAnnotation) {
        this.entityAnnotation = entityAnnotation;
    }

    public void setSupertypeAnnotation(Class<? extends Annotation> supertypeAnnotation) {
        this.supertypeAnnotation = supertypeAnnotation;
    }

    public void setEmbeddableAnnotation(Class<? extends Annotation> embeddableAnnotation) {
        this.embeddableAnnotation = embeddableAnnotation;
    }

    public void setEmbeddedAnnotation(Class<? extends Annotation> embeddedAnnotation) {
        this.embeddedAnnotation = embeddedAnnotation;
    }

    public void setSkipAnnotation(Class<? extends Annotation> skipAnnotation) {
        this.skipAnnotation = skipAnnotation;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.codegenModule.bind(serializerClass);
        this.serializerClass = serializerClass;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }
}

