/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.Types;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.path.ArrayPath;
import com.mysema.query.types.path.BeanPath;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.CollectionPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.ListPath;
import com.mysema.query.types.path.MapPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.PathInits;
import com.mysema.query.types.path.SetPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringUtils;

@Immutable
public class EntitySerializer
implements Serializer {
    private static final Parameter PATH_METADATA = new Parameter("metadata", (Type)new ClassType(PathMetadata.class, new Type[]{null}));
    private static final Parameter PATH_INITS = new Parameter("inits", (Type)new ClassType(PathInits.class, new Type[0]));
    protected final TypeMappings typeMappings;
    protected final Collection<String> keywords;

    @Inject
    public EntitySerializer(TypeMappings mappings, @Named(value="keywords") Collection<String> keywords) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)mappings, (String)"mappings");
        this.keywords = (Collection)Assert.notNull(keywords, (String)"keywords");
    }

    protected void constructors(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        ClassType type;
        String localName = writer.getRawName((Type)model);
        String genericName = writer.getGenericName(true, (Type)model);
        boolean hasEntityFields = model.hasEntityFields();
        String thisOrSuper = hasEntityFields ? "this" : "super";
        boolean stringOrBoolean = model.getOriginalCategory() == TypeCategory.STRING || model.getOriginalCategory() == TypeCategory.BOOLEAN;
        this.constructorsForVariables(writer, model);
        if (!hasEntityFields) {
            if (model.isFinal()) {
                type = new ClassType(BeanPath.class, new Type[]{model});
                writer.beginConstructor(new Parameter[]{new Parameter("entity", (Type)type)});
            } else {
                type = new ClassType(BeanPath.class, new Type[]{new TypeExtends((Type)model)});
                writer.beginConstructor(new Parameter[]{new Parameter("entity", (Type)type)});
            }
            if (stringOrBoolean) {
                writer.line(new String[]{"super(entity.getMetadata());"});
            } else {
                writer.line(new String[]{"super(entity.getType(), entity.getMetadata());"});
            }
            writer.end();
        }
        if (hasEntityFields) {
            writer.beginConstructor(new Parameter[]{PATH_METADATA});
            writer.line(new String[]{"this(metadata, metadata.isRoot() ? INITS : PathInits.DEFAULT);"});
            writer.end();
        } else {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor(new Parameter[]{PATH_METADATA});
            if (stringOrBoolean) {
                writer.line(new String[]{"super(metadata);"});
            } else {
                writer.line(new String[]{"super(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata);"});
            }
            writer.end();
        }
        if (hasEntityFields) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            writer.beginConstructor(new Parameter[]{PATH_METADATA, PATH_INITS});
            writer.line(new String[]{thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, metadata, inits);"});
            writer.end();
        }
        if (hasEntityFields) {
            type = model.isFinal() ? new ClassType(Class.class, new Type[]{model}) : new ClassType(Class.class, new Type[]{new TypeExtends((Type)model)});
            writer.beginConstructor(new Parameter[]{new Parameter("type", (Type)type), PATH_METADATA, PATH_INITS});
            writer.line(new String[]{"super(type, metadata, inits);"});
            this.initEntityFields(writer, config, model);
            writer.end();
        }
    }

    protected void constructorsForVariables(CodeWriter writer, EntityType model) throws IOException {
        String thisOrSuper;
        String localName = writer.getRawName((Type)model);
        String genericName = writer.getGenericName(true, (Type)model);
        boolean hasEntityFields = model.hasEntityFields();
        String string = thisOrSuper = hasEntityFields ? "this" : "super";
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("unchecked");
        }
        writer.beginConstructor(new Parameter[]{new Parameter("variable", (Type)Types.STRING)});
        writer.line(new String[]{thisOrSuper, "(", localName.equals(genericName) ? "" : "(Class)", localName, ".class, forVariable(variable)", hasEntityFields ? ", INITS" : "", ");"});
        writer.end();
    }

    protected void entityAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        writer.beginPublicMethod(queryType, field.getEscapedName(), new Parameter[0]);
        writer.line(new String[]{"if (", field.getEscapedName(), " == null){"});
        writer.line(new String[]{"    ", field.getEscapedName(), " = new ", writer.getRawName(queryType), "(forProperty(\"", field.getName(), "\"));"});
        writer.line(new String[]{"}"});
        writer.line(new String[]{"return ", field.getEscapedName(), ";"});
        writer.end();
    }

    protected void entityField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (field.isInherited()) {
            writer.line(new String[]{"// inherited"});
        }
        if (config.useEntityAccessors()) {
            writer.protectedField(queryType, field.getEscapedName());
        } else {
            writer.publicFinal(queryType, field.getEscapedName());
        }
    }

    protected boolean hasOwnEntityProperties(EntityType model) {
        if (model.hasEntityFields()) {
            for (Property property : model.getProperties()) {
                if (property.isInherited() || property.getType().getCategory() != TypeCategory.ENTITY) continue;
                return true;
            }
        }
        return false;
    }

    protected void initEntityFields(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        Supertype superType = model.getSuperType();
        if (superType != null && superType.getEntityType() == null) {
            throw new IllegalStateException("No entity type for " + superType.getType().getFullName());
        }
        if (superType != null && superType.getEntityType().hasEntityFields()) {
            Type superQueryType = this.typeMappings.getPathType((Type)superType.getEntityType(), model, false);
            writer.line(new String[]{"this._super = new " + writer.getRawName(superQueryType) + "(type, metadata, inits);"});
        }
        for (Property field : model.getProperties()) {
            if (field.getType().getCategory() == TypeCategory.ENTITY) {
                this.initEntityField(writer, config, model, field);
                continue;
            }
            if (!field.isInherited() || superType == null || !superType.getEntityType().hasEntityFields()) continue;
            writer.line(new String[]{"this.", field.getEscapedName(), " = _super.", field.getEscapedName(), ";"});
        }
    }

    protected void initEntityField(CodeWriter writer, SerializerConfig config, EntityType model, Property field) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (!field.isInherited()) {
            boolean hasEntityFields = field.getType() instanceof EntityType && ((EntityType)field.getType()).hasEntityFields();
            writer.line(new String[]{"this." + field.getEscapedName() + " = ", "inits.isInitialized(\"" + field.getName() + "\") ? ", "new " + writer.getRawName(queryType) + "(forProperty(\"" + field.getName() + "\")", hasEntityFields ? ", inits.get(\"" + field.getName() + "\")" : "", ") : null;"});
        } else if (!config.useEntityAccessors()) {
            writer.line(new String[]{"this.", field.getEscapedName(), " = ", "_super.", field.getEscapedName(), ";"});
        }
    }

    protected void intro(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.introPackage(writer, model);
        this.introImports(writer, config, model);
        writer.nl();
        this.introJavadoc(writer, model);
        this.introClassHeader(writer, model);
        this.introFactoryMethods(writer, model);
        this.introInits(writer, model);
        if (config.createDefaultVariable()) {
            this.introDefaultInstance(writer, model);
        }
        if (model.getSuperType() != null && model.getSuperType().getEntityType() != null) {
            this.introSuper(writer, model);
        }
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class pathType;
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            switch (category) {
                case COMPARABLE: {
                    pathType = ComparablePath.class;
                    break;
                }
                case ENUM: {
                    pathType = EnumPath.class;
                    break;
                }
                case DATE: {
                    pathType = DatePath.class;
                    break;
                }
                case DATETIME: {
                    pathType = DateTimePath.class;
                    break;
                }
                case TIME: {
                    pathType = TimePath.class;
                    break;
                }
                case NUMERIC: {
                    pathType = NumberPath.class;
                    break;
                }
                case STRING: {
                    pathType = StringPath.class;
                    break;
                }
                case BOOLEAN: {
                    pathType = BooleanPath.class;
                    break;
                }
                default: {
                    pathType = EntityPathBase.class;
                    break;
                }
            }
        } else {
            pathType = EntityPathBase.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, (Type)new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, (Type)new ClassType(category, pathType, new Type[]{model}), new Type[0]);
        }
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType model) throws IOException {
        String simpleName = model.getUncapSimpleName();
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        String alias = simpleName;
        if (this.keywords.contains(simpleName.toUpperCase())) {
            alias = alias + "1";
        }
        writer.publicStaticFinal(queryType, simpleName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
    }

    protected void introFactoryMethods(CodeWriter writer, final EntityType model) throws IOException {
        String localName = writer.getRawName((Type)model);
        String genericName = writer.getGenericName(true, (Type)model);
        for (Constructor c : model.getConstructors()) {
            if (!localName.equals(genericName)) {
                writer.suppressWarnings("unchecked");
            }
            ClassType returnType = new ClassType(ConstructorExpression.class, new Type[]{model});
            writer.beginStaticMethod((Type)returnType, "create", c.getParameters(), (Transformer)new Transformer<Parameter, Parameter>(){

                public Parameter transform(Parameter p) {
                    return new Parameter(p.getName(), EntitySerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true));
                }
            });
            writer.beginLine(new String[]{"return new ConstructorExpression<" + genericName + ">("});
            if (!localName.equals(genericName)) {
                writer.append((CharSequence)"(Class)");
            }
            writer.append((CharSequence)(localName + ".class"));
            writer.append((CharSequence)", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append((CharSequence)", ");
                }
                if (p.getType().getPrimitiveName() != null) {
                    writer.append((CharSequence)(p.getType().getPrimitiveName() + ".class"));
                } else {
                    writer.append((CharSequence)writer.getRawName(p.getType()));
                    writer.append((CharSequence)".class");
                }
                first = false;
            }
            writer.append((CharSequence)"}");
            for (Parameter p : c.getParameters()) {
                writer.append((CharSequence)(", " + p.getName()));
            }
            writer.append((CharSequence)");\n");
            writer.end();
        }
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        writer.staticimports(new Class[]{PathMetadataFactory.class});
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        if (!(model.getPackageName().isEmpty() || queryType.getPackageName().equals(model.getPackageName()) || queryType.getSimpleName().equals(model.getSimpleName()))) {
            writer.importClasses(new String[]{model.getFullName()});
        }
        this.introDelegatePackages(writer, model);
        ArrayList<Package> packages = new ArrayList<Package>();
        packages.add(PathMetadata.class.getPackage());
        packages.add(SimplePath.class.getPackage());
        if (!model.getConstructors().isEmpty() || !model.getDelegates().isEmpty()) {
            packages.add(ComparableExpression.class.getPackage());
        }
        writer.imports(packages.toArray(new Package[packages.size()]));
    }

    protected void introDelegatePackages(CodeWriter writer, EntityType model) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        for (Delegate delegate : model.getDelegates()) {
            if (delegate.getDelegateType().getPackageName().equals(model.getPackageName())) continue;
            packages.add(delegate.getDelegateType().getPackageName());
        }
        writer.importPackages(packages.toArray(new String[packages.size()]));
    }

    protected void introInits(CodeWriter writer, EntityType model) throws IOException {
        if (model.hasEntityFields()) {
            ArrayList<String> inits = new ArrayList<String>();
            for (Property property : model.getProperties()) {
                if (property.getType().getCategory() != TypeCategory.ENTITY) continue;
                for (String init : property.getInits()) {
                    inits.add(property.getEscapedName() + "." + init);
                }
            }
            ClassType pathInitsType = new ClassType(PathInits.class, new Type[0]);
            if (!inits.isEmpty()) {
                inits.add(0, "*");
                String initsAsString = "\"" + StringUtils.join(inits, (String)"\", \"") + "\"";
                writer.privateStaticFinal((Type)pathInitsType, "INITS", "new PathInits(" + initsAsString + ")");
            } else {
                writer.privateStaticFinal((Type)pathInitsType, "INITS", "PathInits.DIRECT");
            }
        }
    }

    protected void introJavadoc(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        writer.javadoc(new String[]{queryType.getSimpleName() + " is a Querydsl query type for " + model.getSimpleName()});
    }

    protected void introPackage(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
    }

    protected void introSuper(CodeWriter writer, EntityType model) throws IOException {
        EntityType superType = model.getSuperType().getEntityType();
        Type superQueryType = this.typeMappings.getPathType((Type)superType, model, false);
        if (!superType.hasEntityFields()) {
            writer.publicFinal(superQueryType, "_super", "new " + writer.getRawName(superQueryType) + "(this)");
        } else {
            writer.publicFinal(superQueryType, "_super");
        }
    }

    protected void listAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        Type queryType = this.typeMappings.getPathType(field.getParameter(0), model, false);
        writer.beginPublicMethod(queryType, escapedName, new Parameter[]{new Parameter("index", (Type)Types.INT)});
        writer.line(new String[]{"return " + escapedName + ".get(index);"}).end();
        writer.beginPublicMethod(queryType, escapedName, new Parameter[]{new Parameter("index", (Type)new ClassType(Expression.class, new Type[]{Types.INTEGER}))});
        writer.line(new String[]{"return " + escapedName + ".get(index);"}).end();
    }

    protected void mapAccessor(EntityType model, Property field, CodeWriter writer) throws IOException {
        String escapedName = field.getEscapedName();
        Type queryType = this.typeMappings.getPathType(field.getParameter(1), model, false);
        writer.beginPublicMethod(queryType, escapedName, new Parameter[]{new Parameter("key", field.getParameter(0))});
        writer.line(new String[]{"return " + escapedName + ".get(key);"}).end();
        writer.beginPublicMethod(queryType, escapedName, new Parameter[]{new Parameter("key", (Type)new ClassType(Expression.class, new Type[]{field.getParameter(0)}))});
        writer.line(new String[]{"return " + escapedName + ".get(key);"}).end();
    }

    private void delegate(EntityType model, Delegate delegate, SerializerConfig config, CodeWriter writer) throws IOException {
        Parameter[] params = delegate.getParameters().toArray(new Parameter[delegate.getParameters().size()]);
        writer.beginPublicMethod(delegate.getReturnType(), delegate.getName(), params);
        writer.beginLine(new String[]{"return " + delegate.getDelegateType().getSimpleName() + "." + delegate.getName() + "("});
        writer.append((CharSequence)"this");
        if (!model.equals(delegate.getDeclaringType())) {
            int counter = 0;
            EntityType type = model;
            while (type != null && !type.equals(delegate.getDeclaringType())) {
                type = type.getSuperType() != null ? type.getSuperType().getEntityType() : null;
                ++counter;
            }
            for (int i = 0; i < counter; ++i) {
                writer.append((CharSequence)"._super");
            }
        }
        for (Parameter parameter : delegate.getParameters()) {
            writer.append((CharSequence)(", " + parameter.getName()));
        }
        writer.append((CharSequence)");\n");
        writer.end();
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        this.intro(model, config, writer);
        this.serializeProperties(model, config, writer);
        this.constructors(model, config, writer);
        for (Delegate delegate : model.getDelegates()) {
            this.delegate(model, delegate, config, writer);
        }
        for (Property property : model.getProperties()) {
            TypeCategory category = property.getType().getCategory();
            if (category == TypeCategory.MAP && config.useMapAccessors()) {
                this.mapAccessor(model, property, writer);
                continue;
            }
            if (category == TypeCategory.LIST && config.useListAccessors()) {
                this.listAccessor(model, property, writer);
                continue;
            }
            if (category != TypeCategory.ENTITY || !config.useEntityAccessors()) continue;
            this.entityAccessor(model, property, writer);
        }
        this.outro(model, writer);
    }

    protected void serialize(EntityType model, Property field, Type type, CodeWriter writer, String factoryMethod, String ... args) throws IOException {
        Supertype superType = model.getSuperType();
        StringBuilder value = new StringBuilder();
        if (field.isInherited() && superType != null) {
            if (!superType.getEntityType().hasEntityFields()) {
                value.append("_super." + field.getEscapedName());
            }
        } else {
            value.append(factoryMethod + "(\"" + field.getName() + "\"");
            for (String arg : args) {
                value.append(", " + arg);
            }
            value.append(")");
        }
        if (field.isInherited()) {
            writer.line(new String[]{"//inherited"});
        }
        if (value.length() > 0) {
            writer.publicFinal(type, field.getEscapedName(), value.toString());
        } else {
            writer.publicFinal(type, field.getEscapedName());
        }
    }

    private void customField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        writer.line(new String[]{"// custom"});
        if (field.isInherited()) {
            writer.line(new String[]{"// inherited"});
            Supertype superType = model.getSuperType();
            if (!superType.getEntityType().hasEntityFields()) {
                writer.publicFinal(queryType, field.getEscapedName(), "_super." + field.getEscapedName());
            } else {
                writer.publicFinal(queryType, field.getEscapedName());
            }
        } else {
            String value = "new " + writer.getRawName(queryType) + "(forProperty(\"" + field.getName() + "\"))";
            writer.publicFinal(queryType, field.getEscapedName(), value);
        }
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        for (Property property : model.getProperties()) {
            if (this.typeMappings.isRegistered(property.getType()) && property.getType().getCategory() != TypeCategory.CUSTOM && property.getType().getCategory() != TypeCategory.ENTITY) {
                this.customField(model, property, config, writer);
                continue;
            }
            SimpleType propertyType = new SimpleType(property.getType(), property.getType().getParameters());
            Type queryType = this.typeMappings.getPathType((Type)propertyType, model, false);
            Type genericQueryType = null;
            String localRawName = writer.getRawName(property.getType());
            switch (property.getType().getCategory()) {
                case STRING: {
                    this.serialize(model, property, queryType, writer, "createString", new String[0]);
                    break;
                }
                case BOOLEAN: {
                    this.serialize(model, property, queryType, writer, "createBoolean", new String[0]);
                    break;
                }
                case SIMPLE: {
                    this.serialize(model, property, queryType, writer, "createSimple", localRawName + ".class");
                    break;
                }
                case COMPARABLE: {
                    this.serialize(model, property, queryType, writer, "createComparable", localRawName + ".class");
                    break;
                }
                case ENUM: {
                    this.serialize(model, property, queryType, writer, "createEnum", localRawName + ".class");
                    break;
                }
                case DATE: {
                    this.serialize(model, property, queryType, writer, "createDate", localRawName + ".class");
                    break;
                }
                case DATETIME: {
                    this.serialize(model, property, queryType, writer, "createDateTime", localRawName + ".class");
                    break;
                }
                case TIME: {
                    this.serialize(model, property, queryType, writer, "createTime", localRawName + ".class");
                    break;
                }
                case NUMERIC: {
                    this.serialize(model, property, queryType, writer, "createNumber", localRawName + ".class");
                    break;
                }
                case CUSTOM: {
                    this.customField(model, property, config, writer);
                    break;
                }
                case ARRAY: {
                    this.serialize(model, property, (Type)new ClassType(ArrayPath.class, new Type[]{property.getType().getComponentType()}), writer, "createArray", localRawName + ".class");
                    break;
                }
                case COLLECTION: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, (Type)new ClassType(CollectionPath.class, new Type[]{this.getRaw(property.getParameter(0)), genericQueryType}), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createCollection", localRawName + ".class", writer.getRawName(queryType) + ".class");
                    break;
                }
                case SET: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, (Type)new ClassType(SetPath.class, new Type[]{this.getRaw(property.getParameter(0)), genericQueryType}), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createSet", localRawName + ".class", writer.getRawName(queryType) + ".class");
                    break;
                }
                case LIST: {
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(0)), model, false);
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    localRawName = writer.getRawName(property.getParameter(0));
                    queryType = this.typeMappings.getPathType(property.getParameter(0), model, true);
                    this.serialize(model, property, (Type)new ClassType(ListPath.class, new Type[]{this.getRaw(property.getParameter(0)), genericQueryType}), writer, "this.<" + genericKey + ", " + writer.getGenericName(true, genericQueryType) + ">createList", localRawName + ".class", writer.getRawName(queryType) + ".class");
                    break;
                }
                case MAP: {
                    String genericKey = writer.getGenericName(true, property.getParameter(0));
                    String genericValue = writer.getGenericName(true, property.getParameter(1));
                    genericQueryType = this.typeMappings.getPathType(this.getRaw(property.getParameter(1)), model, false);
                    String keyType = writer.getRawName(property.getParameter(0));
                    String valueType = writer.getRawName(property.getParameter(1));
                    queryType = this.typeMappings.getPathType(property.getParameter(1), model, true);
                    this.serialize(model, property, (Type)new ClassType(MapPath.class, new Type[]{this.getRaw(property.getParameter(0)), this.getRaw(property.getParameter(1)), genericQueryType}), writer, "this.<" + genericKey + ", " + genericValue + ", " + writer.getGenericName(true, genericQueryType) + ">createMap", keyType + ".class", valueType + ".class", writer.getRawName(queryType) + ".class");
                    break;
                }
                case ENTITY: {
                    this.entityField(model, property, config, writer);
                }
            }
        }
    }

    private Type getRaw(Type type) {
        if (type instanceof EntityType && type.getPackageName().startsWith("ext.java")) {
            return type;
        }
        return new SimpleType(type, type.getParameters());
    }
}

