/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.ComparableOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringOperation;
import javax.annotation.Nullable;

public abstract class StringExpression
extends ComparableExpression<String> {
    private static final long serialVersionUID = 1536955079961023361L;
    @Nullable
    private volatile NumberExpression<Integer> length;
    @Nullable
    private volatile StringExpression lower;
    @Nullable
    private volatile StringExpression trim;
    @Nullable
    private volatile StringExpression upper;
    @Nullable
    private volatile BooleanExpression isempty;

    public StringExpression() {
        super(String.class);
    }

    public StringExpression as(Path<String> alias) {
        return StringOperation.create(Ops.ALIAS, this, alias);
    }

    @Override
    public StringExpression as(String alias) {
        return StringOperation.create(Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public StringExpression append(Expression<String> str) {
        return StringOperation.create(Ops.CONCAT, this, str);
    }

    public StringExpression append(String str) {
        return this.append(ConstantImpl.create(str));
    }

    public SimpleExpression<Character> charAt(Expression<Integer> i) {
        return ComparableOperation.create(Character.class, Ops.CHAR_AT, this, i);
    }

    public SimpleExpression<Character> charAt(int i) {
        return this.charAt(ConstantImpl.create(i));
    }

    public StringExpression concat(Expression<String> str) {
        return this.append(str);
    }

    public StringExpression concat(String str) {
        return this.append(str);
    }

    public BooleanExpression contains(Expression<String> str) {
        return BooleanOperation.create(Ops.STRING_CONTAINS, this, str);
    }

    public BooleanExpression contains(String str) {
        return this.contains(ConstantImpl.create(str));
    }

    public BooleanExpression containsIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.STRING_CONTAINS_IC, this, str);
    }

    public BooleanExpression containsIgnoreCase(String str) {
        return this.containsIgnoreCase(ConstantImpl.create(str));
    }

    public BooleanExpression endsWith(Expression<String> str) {
        return BooleanOperation.create(Ops.ENDS_WITH, this, str);
    }

    public BooleanExpression endsWithIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.ENDS_WITH_IC, this, str);
    }

    public BooleanExpression endsWith(String str) {
        return this.endsWith(ConstantImpl.create(str));
    }

    public BooleanExpression endsWithIgnoreCase(String str) {
        return this.endsWithIgnoreCase(ConstantImpl.create(str));
    }

    public BooleanExpression equalsIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.EQ_IGNORE_CASE, this, str);
    }

    public BooleanExpression equalsIgnoreCase(String str) {
        return this.equalsIgnoreCase(ConstantImpl.create(str));
    }

    public NumberExpression<Integer> indexOf(Expression<String> str) {
        return NumberOperation.create(Integer.class, Ops.INDEX_OF, this, str);
    }

    public NumberExpression<Integer> indexOf(String str) {
        return this.indexOf(ConstantImpl.create(str));
    }

    public NumberExpression<Integer> indexOf(String str, int i) {
        return this.indexOf(ConstantImpl.create(str), i);
    }

    public NumberExpression<Integer> indexOf(Expression<String> str, int i) {
        return NumberOperation.create(Integer.class, Ops.INDEX_OF_2ARGS, this, str, ConstantImpl.create(i));
    }

    public BooleanExpression isEmpty() {
        if (this.isempty == null) {
            this.isempty = BooleanOperation.create(Ops.STRING_IS_EMPTY, this);
        }
        return this.isempty;
    }

    public BooleanExpression isNotEmpty() {
        return this.isEmpty().not();
    }

    public NumberExpression<Integer> length() {
        if (this.length == null) {
            this.length = NumberOperation.create(Integer.class, Ops.STRING_LENGTH, this);
        }
        return this.length;
    }

    public BooleanExpression like(String str) {
        return BooleanOperation.create(Ops.LIKE, this, ConstantImpl.create(str));
    }

    public BooleanExpression like(StringExpression str) {
        return BooleanOperation.create(Ops.LIKE, this, str);
    }

    public StringExpression lower() {
        if (this.lower == null) {
            this.lower = StringOperation.create(Ops.LOWER, this);
        }
        return this.lower;
    }

    public BooleanExpression matches(Expression<String> regex) {
        return BooleanOperation.create(Ops.MATCHES, this, regex);
    }

    public BooleanExpression matches(String regex) {
        return this.matches(ConstantImpl.create(regex));
    }

    public StringExpression prepend(Expression<String> str) {
        return StringOperation.create(Ops.CONCAT, str, this);
    }

    public StringExpression prepend(String str) {
        return this.prepend(ConstantImpl.create(str));
    }

    public SimpleExpression<String[]> split(String regex) {
        return SimpleOperation.create(String[].class, Ops.StringOps.SPLIT, this, ConstantImpl.create(regex));
    }

    public BooleanExpression startsWith(Expression<String> str) {
        return BooleanOperation.create(Ops.STARTS_WITH, this, str);
    }

    public BooleanExpression startsWithIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.STARTS_WITH_IC, this, str);
    }

    public BooleanExpression startsWith(String str) {
        return this.startsWith(ConstantImpl.create(str));
    }

    public BooleanExpression startsWithIgnoreCase(String str) {
        return this.startsWithIgnoreCase(ConstantImpl.create(str));
    }

    @Override
    public StringExpression stringValue() {
        return this;
    }

    public StringExpression substring(int beginIndex) {
        return StringOperation.create(Ops.SUBSTR_1ARG, this, ConstantImpl.create(beginIndex));
    }

    public StringExpression substring(int beginIndex, int endIndex) {
        return StringOperation.create(Ops.SUBSTR_2ARGS, this, ConstantImpl.create(beginIndex), ConstantImpl.create(endIndex));
    }

    public StringExpression toLowerCase() {
        return this.lower();
    }

    public StringExpression toUpperCase() {
        return this.upper();
    }

    public StringExpression trim() {
        if (this.trim == null) {
            this.trim = StringOperation.create(Ops.TRIM, this);
        }
        return this.trim;
    }

    public StringExpression upper() {
        if (this.upper == null) {
            this.upper = StringOperation.create(Ops.UPPER, this);
        }
        return this.upper;
    }
}

