/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.CaseForEqBuilder;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public abstract class SimpleExpression<D>
extends ExpressionBase<D> {
    private static final long serialVersionUID = -4405387187738167105L;
    @Nullable
    private volatile NumberExpression<Long> count;
    @Nullable
    private volatile NumberExpression<Long> countDistinct;
    @Nullable
    private volatile BooleanExpression isnull;
    @Nullable
    private volatile BooleanExpression isnotnull;
    protected final boolean primitive;

    public SimpleExpression(Class<? extends D> type) {
        super(type);
        this.primitive = type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }

    public BooleanExpression isNotNull() {
        if (this.isnotnull == null) {
            this.isnotnull = BooleanOperation.create(Ops.IS_NOT_NULL, this);
        }
        return this.isnotnull;
    }

    public BooleanExpression isNull() {
        if (this.isnull == null) {
            this.isnull = BooleanOperation.create(Ops.IS_NULL, this);
        }
        return this.isnull;
    }

    public SimpleExpression<D> as(Path<D> alias) {
        return SimpleOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public SimpleExpression<D> as(String alias) {
        return SimpleOperation.create(this.getType(), Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public NumberExpression<Long> count() {
        if (this.count == null) {
            this.count = NumberOperation.create(Long.class, Ops.AggOps.COUNT_AGG, this);
        }
        return this.count;
    }

    public NumberExpression<Long> countDistinct() {
        if (this.countDistinct == null) {
            this.countDistinct = NumberOperation.create(Long.class, Ops.AggOps.COUNT_DISTINCT_AGG, this);
        }
        return this.countDistinct;
    }

    public BooleanExpression eq(D right) {
        return this.eq((Expression<? super D>)new ConstantImpl<D>(right));
    }

    public BooleanExpression eq(Expression<? super D> right) {
        if (this.primitive) {
            return BooleanOperation.create(Ops.EQ_PRIMITIVE, this, right);
        }
        return BooleanOperation.create(Ops.EQ_OBJECT, this, right);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.type.hashCode();
    }

    public BooleanExpression in(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.eq(right.iterator().next());
        }
        return BooleanOperation.create(Ops.IN, this, new ConstantImpl<Collection<? extends D>>(right));
    }

    public BooleanExpression in(D ... right) {
        if (right.length == 1) {
            return this.eq(right[0]);
        }
        return BooleanOperation.create(Ops.IN, this, new ConstantImpl<List<D>>(Arrays.asList(right)));
    }

    public BooleanExpression in(CollectionExpression<?, ? extends D> right) {
        return BooleanOperation.create(Ops.IN, this, right);
    }

    public BooleanExpression ne(D right) {
        return this.ne((Expression<? super D>)new ConstantImpl<D>(right));
    }

    public BooleanExpression ne(Expression<? super D> right) {
        if (this.primitive) {
            return BooleanOperation.create(Ops.NE_PRIMITIVE, this, right);
        }
        return BooleanOperation.create(Ops.NE_OBJECT, this, right);
    }

    public final BooleanExpression notIn(Collection<? extends D> right) {
        if (right.size() == 1) {
            return this.ne(right.iterator().next());
        }
        return this.in(right).not();
    }

    public BooleanExpression notIn(D ... right) {
        if (right.length == 1) {
            return this.ne(right[0]);
        }
        return this.in(right).not();
    }

    public final BooleanExpression notIn(CollectionExpression<?, ? extends D> right) {
        return this.in(right).not();
    }

    public CaseForEqBuilder<D> when(D other) {
        return new CaseForEqBuilder<D>(this, new ConstantImpl<D>(other));
    }

    public CaseForEqBuilder<D> when(Expression<? extends D> other) {
        return new CaseForEqBuilder<D>(this, other);
    }
}

