/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.util.MathUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class NumberExpression<D extends Number>
extends ComparableExpressionBase<D> {
    private static final long serialVersionUID = -5485902768703364888L;
    @Nullable
    private static final NumberExpression<Double> random = NumberOperation.create(Double.class, Ops.MathOps.RANDOM, new Expression[0]);
    @Nullable
    private volatile NumberExpression<D> abs;
    @Nullable
    private volatile NumberExpression<D> sum;
    @Nullable
    private volatile NumberExpression<D> min;
    @Nullable
    private volatile NumberExpression<D> max;
    @Nullable
    private volatile NumberExpression<D> floor;
    @Nullable
    private volatile NumberExpression<D> ceil;
    @Nullable
    private volatile NumberExpression<Double> avg;
    @Nullable
    private volatile NumberExpression<Double> sqrt;
    @Nullable
    private volatile NumberExpression<D> negation;
    @Nullable
    private volatile NumberExpression<Integer> round;

    public static <A extends Number> NumberExpression<A> max(Expression<A> left, Expression<A> right) {
        return NumberOperation.create(left.getType(), Ops.MathOps.MAX, left, right);
    }

    public static <A extends Number> NumberExpression<A> min(Expression<A> left, Expression<A> right) {
        return NumberOperation.create(left.getType(), Ops.MathOps.MIN, left, right);
    }

    public static NumberExpression<Double> random() {
        return random;
    }

    public NumberExpression(Class<? extends D> type) {
        super(type);
    }

    @Override
    public NumberExpression<D> as(Path<D> alias) {
        return NumberOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public NumberExpression<D> as(String alias) {
        return NumberOperation.create(this.getType(), Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public NumberExpression<D> abs() {
        if (this.abs == null) {
            this.abs = NumberOperation.create(this.getType(), Ops.MathOps.ABS, this);
        }
        return this.abs;
    }

    public <N extends Number> NumberExpression<D> add(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.ADD, this, right);
    }

    public <N extends Number> NumberExpression<D> add(N right) {
        return NumberOperation.create(this.getType(), Ops.ADD, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<Double> avg() {
        if (this.avg == null) {
            this.avg = NumberOperation.create(Double.class, Ops.AggOps.AVG_AGG, this);
        }
        return this.avg;
    }

    public NumberExpression<Byte> byteValue() {
        return this.castToNum(Byte.class);
    }

    private D cast(Number number) {
        Class type = this.getType();
        if (type.equals(number.getClass())) {
            return (D)number;
        }
        if (Byte.class.equals(type)) {
            return (D)Byte.valueOf(number.byteValue());
        }
        if (Double.class.equals(type)) {
            return (D)Double.valueOf(number.doubleValue());
        }
        if (Float.class.equals(type)) {
            return (D)Float.valueOf(number.floatValue());
        }
        if (Integer.class.equals(type)) {
            return (D)Integer.valueOf(number.intValue());
        }
        if (Long.class.equals(type)) {
            return (D)Long.valueOf(number.longValue());
        }
        if (Short.class.equals(type)) {
            return (D)Short.valueOf(number.shortValue());
        }
        if (BigInteger.class.equals(type)) {
            return (D)new BigInteger(String.valueOf(number.longValue()));
        }
        if (BigDecimal.class.equals(type)) {
            return (D)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Unsupported target type : " + type.getName());
    }

    @Override
    public <A extends Number> NumberExpression<A> castToNum(Class<A> type) {
        if (type.equals(this.getType())) {
            return this;
        }
        return NumberOperation.create(type, Ops.NUMCAST, this, new ConstantImpl<Class<A>>(type));
    }

    public NumberExpression<D> ceil() {
        if (this.ceil == null) {
            this.ceil = NumberOperation.create(this.getType(), Ops.MathOps.CEIL, this);
        }
        return this.ceil;
    }

    public <N extends Number> NumberExpression<Double> divide(Expression<N> right) {
        return NumberOperation.create(Double.class, Ops.DIV, this, right);
    }

    public <N extends Number> NumberExpression<Double> divide(N right) {
        return NumberOperation.create(Double.class, Ops.DIV, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<Double> doubleValue() {
        return this.castToNum(Double.class);
    }

    public NumberExpression<Float> floatValue() {
        return this.castToNum(Float.class);
    }

    public NumberExpression<D> floor() {
        if (this.floor == null) {
            this.floor = NumberOperation.create(this.getType(), Ops.MathOps.FLOOR, this);
        }
        return this.floor;
    }

    public final <A extends Number> BooleanExpression goe(A right) {
        return this.goe(new ConstantImpl<D>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression goe(Expression<A> right) {
        return BooleanOperation.create(Ops.GOE, this, right);
    }

    public final <A extends Number> BooleanExpression gt(A right) {
        return this.gt(new ConstantImpl<D>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression between(A from, A to) {
        return BooleanOperation.create(Ops.BETWEEN, this, new ConstantImpl<A>(from), new ConstantImpl<A>(to));
    }

    public final <A extends Number> BooleanExpression between(Expression<A> from, Expression<A> to) {
        return BooleanOperation.create(Ops.BETWEEN, this, from, to);
    }

    public final <A extends Number> BooleanExpression notBetween(A from, A to) {
        return this.between(from, to).not();
    }

    public final <A extends Number> BooleanExpression notBetween(Expression<A> from, Expression<A> to) {
        return this.between(from, to).not();
    }

    public final <A extends Number> BooleanExpression gt(Expression<A> right) {
        return BooleanOperation.create(Ops.GT, this, right);
    }

    public NumberExpression<Integer> intValue() {
        return this.castToNum(Integer.class);
    }

    public final <A extends Number> BooleanExpression loe(A right) {
        return this.loe(new ConstantImpl<D>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression loe(Expression<A> right) {
        return BooleanOperation.create(Ops.LOE, this, right);
    }

    public NumberExpression<Long> longValue() {
        return this.castToNum(Long.class);
    }

    public final <A extends Number> BooleanExpression lt(A right) {
        return this.lt(new ConstantImpl<D>(this.cast(right)));
    }

    public final <A extends Number> BooleanExpression lt(Expression<A> right) {
        return BooleanOperation.create(Ops.LT, this, right);
    }

    public NumberExpression<D> max() {
        if (this.max == null) {
            this.max = NumberOperation.create(this.getType(), Ops.AggOps.MAX_AGG, this);
        }
        return this.max;
    }

    public NumberExpression<D> min() {
        if (this.min == null) {
            this.min = NumberOperation.create(this.getType(), Ops.AggOps.MIN_AGG, this);
        }
        return this.min;
    }

    public NumberExpression<D> mod(NumberExpression<D> num) {
        return NumberOperation.create(this.getType(), Ops.MOD, this, num);
    }

    public NumberExpression<D> mod(D num) {
        return NumberOperation.create(this.getType(), Ops.MOD, this, new ConstantImpl<D>(num));
    }

    public <N extends Number> NumberExpression<D> multiply(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.MULT, this, right);
    }

    public <N extends Number> NumberExpression<D> multiply(N right) {
        return NumberOperation.create(this.getType(), Ops.MULT, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<D> negate() {
        if (this.negation == null) {
            this.negation = this.multiply(-1);
        }
        return this.negation;
    }

    public NumberExpression<Integer> round() {
        if (this.round == null) {
            this.round = NumberOperation.create(Integer.class, Ops.MathOps.ROUND, this);
        }
        return this.round;
    }

    public NumberExpression<Short> shortValue() {
        return this.castToNum(Short.class);
    }

    public NumberExpression<Double> sqrt() {
        if (this.sqrt == null) {
            this.sqrt = NumberOperation.create(Double.class, Ops.MathOps.SQRT, this);
        }
        return this.sqrt;
    }

    public <N extends Number> NumberExpression<D> subtract(Expression<N> right) {
        return NumberOperation.create(this.getType(), Ops.SUB, this, right);
    }

    public <N extends Number> NumberExpression<D> subtract(N right) {
        return NumberOperation.create(this.getType(), Ops.SUB, this, new ConstantImpl<N>(right));
    }

    public NumberExpression<D> sum() {
        if (this.sum == null) {
            this.sum = NumberOperation.create(this.getType(), Ops.AggOps.SUM_AGG, this);
        }
        return this.sum;
    }

    public BooleanExpression in(Number ... numbers) {
        return super.in(this.convert(numbers));
    }

    public BooleanExpression notIn(Number ... numbers) {
        return super.notIn(this.convert(numbers));
    }

    private List<D> convert(Number ... numbers) {
        ArrayList list = new ArrayList(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            list.add(MathUtils.cast(numbers[i], this.getType()));
        }
        return list;
    }
}

