/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MapExpressionBase<K, V>
extends SimpleExpression<Map<K, V>>
implements MapExpression<K, V> {
    private static final long serialVersionUID = 2856001983312366841L;
    @Nullable
    private volatile NumberExpression<Integer> size;
    @Nullable
    private volatile BooleanExpression empty;

    public MapExpressionBase(Class<? extends Map<K, V>> type) {
        super(type);
    }

    public final BooleanExpression contains(K key, V value) {
        return this.get(key).eq(value);
    }

    public final BooleanExpression contains(Expression<K> key, Expression<V> value) {
        return this.get((K)key).eq(value);
    }

    public final BooleanExpression containsKey(Expression<K> key) {
        return BooleanOperation.create(Ops.CONTAINS_KEY, this, key);
    }

    public final BooleanExpression containsKey(K key) {
        return BooleanOperation.create(Ops.CONTAINS_KEY, this, new ConstantImpl<K>(key));
    }

    public final BooleanExpression containsValue(Expression<V> value) {
        return BooleanOperation.create(Ops.CONTAINS_VALUE, this, value);
    }

    public final BooleanExpression containsValue(V value) {
        return BooleanOperation.create(Ops.CONTAINS_VALUE, this, new ConstantImpl<V>(value));
    }

    public abstract SimpleExpression<V> get(Expression<K> var1);

    public abstract SimpleExpression<V> get(K var1);

    public final BooleanExpression isEmpty() {
        if (this.empty == null) {
            this.empty = BooleanOperation.create(Ops.MAP_IS_EMPTY, this);
        }
        return this.empty;
    }

    public final BooleanExpression isNotEmpty() {
        return this.isEmpty().not();
    }

    public final NumberExpression<Integer> size() {
        if (this.size == null) {
            this.size = NumberOperation.create(Integer.class, Ops.MAP_SIZE, this);
        }
        return this.size;
    }
}

