/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpressionBase;
import com.mysema.query.types.expr.ComparableOperation;

public abstract class ComparableExpression<D extends Comparable>
extends ComparableExpressionBase<D> {
    private static final long serialVersionUID = 5761359576767404270L;

    public ComparableExpression(Class<? extends D> type) {
        super(type);
    }

    @Override
    public ComparableExpression<D> as(Path<D> alias) {
        return ComparableOperation.create(this.getType(), Ops.ALIAS, this, alias);
    }

    @Override
    public ComparableExpression<D> as(String alias) {
        return ComparableOperation.create(this.getType(), Ops.ALIAS, this, new PathImpl(this.getType(), alias));
    }

    public final BooleanExpression between(D from, D to) {
        return BooleanOperation.create(Ops.BETWEEN, this, new ConstantImpl<D>(from), new ConstantImpl<D>(to));
    }

    public final BooleanExpression between(Expression<D> from, Expression<D> to) {
        return BooleanOperation.create(Ops.BETWEEN, this, from, to);
    }

    public final BooleanExpression notBetween(D from, D to) {
        return this.between(from, to).not();
    }

    public final BooleanExpression notBetween(Expression<D> from, Expression<D> to) {
        return this.between(from, to).not();
    }

    public BooleanExpression gt(D right) {
        return this.gt((Expression<D>)new ConstantImpl<D>(right));
    }

    public BooleanExpression gt(Expression<D> right) {
        return BooleanOperation.create(Ops.AFTER, this, right);
    }

    public BooleanExpression goe(D right) {
        return this.goe((Expression<D>)new ConstantImpl<D>(right));
    }

    public BooleanExpression goe(Expression<D> right) {
        return BooleanOperation.create(Ops.AOE, this, right);
    }

    public final BooleanExpression lt(D right) {
        return this.lt((Expression<D>)new ConstantImpl<D>(right));
    }

    public final BooleanExpression lt(Expression<D> right) {
        return BooleanOperation.create(Ops.BEFORE, this, right);
    }

    public final BooleanExpression loe(D right) {
        return BooleanOperation.create(Ops.BOE, this, new ConstantImpl<D>(right));
    }

    public final BooleanExpression loe(Expression<D> right) {
        return BooleanOperation.create(Ops.BOE, this, right);
    }
}

