/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;

public final class ToStringVisitor
implements Visitor<String, Templates> {
    public static final ToStringVisitor DEFAULT = new ToStringVisitor();

    private ToStringVisitor() {
    }

    @Override
    public String visit(TemplateExpression<?> expr, Templates templates) {
        StringBuilder builder = new StringBuilder();
        for (Template.Element element : expr.getTemplate().getElements()) {
            if (element.getStaticText() != null) {
                builder.append(element.getStaticText());
                continue;
            }
            builder.append(expr.getArg(element.getIndex()).accept(this, templates));
        }
        return builder.toString();
    }

    @Override
    public String visit(Constant<?> e, Templates templates) {
        return e.getConstant().toString();
    }

    @Override
    public String visit(FactoryExpression<?> e, Templates templates) {
        StringBuilder builder = new StringBuilder();
        builder.append("new ").append(e.getType().getSimpleName()).append("(");
        boolean first = true;
        for (Expression<?> arg : e.getArgs()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(arg.accept(this, templates));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String visit(Operation<?> o, Templates templates) {
        Template template = templates.getTemplate(o.getOperator());
        if (template != null) {
            StringBuilder builder = new StringBuilder();
            for (Template.Element element : template.getElements()) {
                if (element.getStaticText() != null) {
                    builder.append(element.getStaticText());
                    continue;
                }
                builder.append(o.getArg(element.getIndex()).accept(this, templates));
            }
            return builder.toString();
        }
        return "unknown operation with args " + o.getArgs();
    }

    @Override
    public String visit(Path<?> p, Templates templates) {
        Path<?> parent = p.getMetadata().getParent();
        Expression<?> expr = p.getMetadata().getExpression();
        if (parent != null) {
            Template pattern = templates.getTemplate(p.getMetadata().getPathType());
            if (pattern != null) {
                StringBuilder builder = new StringBuilder();
                for (Template.Element element : pattern.getElements()) {
                    if (element.getStaticText() != null) {
                        builder.append(element.getStaticText());
                        continue;
                    }
                    if (element.getIndex() == 0) {
                        builder.append(parent.accept(this, templates));
                        continue;
                    }
                    if (element.getIndex() != 1) continue;
                    builder.append(expr.accept(this, templates));
                }
                return builder.toString();
            }
            throw new IllegalArgumentException("No pattern for " + p.getMetadata().getPathType());
        }
        return expr.toString();
    }

    @Override
    public String visit(SubQueryExpression<?> expr, Templates templates) {
        return expr.getMetadata().toString();
    }

    @Override
    public String visit(ParamExpression<?> param, Templates templates) {
        return "{" + param.getName() + "}";
    }
}

