/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Path;
import com.mysema.query.types.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.BeanMap;

public class QBean<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = -8210214512730989778L;
    private final Map<String, Expression<?>> bindings;
    private final List<Expression<?>> args;

    public QBean(Path<T> type, Expression<?> ... args) {
        this(type.getType(), args);
    }

    public QBean(Path<T> type, Map<String, Expression<?>> bindings) {
        this(type.getType(), bindings);
    }

    public QBean(Class<T> type, Map<String, Expression<?>> bindings) {
        super(type);
        this.args = new ArrayList(bindings.values());
        this.bindings = bindings;
    }

    public QBean(Class<T> type, Expression<?> ... args) {
        super(type);
        this.args = Arrays.asList(args);
        this.bindings = this.createBindings(args);
    }

    private Map<String, Expression<?>> createBindings(Expression<?> ... args) {
        HashMap rv = new HashMap(args.length);
        for (Expression<?> expr : args) {
            if (expr instanceof Path) {
                Path path = (Path)expr;
                rv.put(path.getMetadata().getExpression().toString(), expr);
                continue;
            }
            if (expr instanceof Operation) {
                Operation operation = (Operation)expr;
                Path alias = (Path)operation.getArg(1);
                rv.put(alias.getMetadata().getExpression().toString(), expr);
                continue;
            }
            throw new IllegalArgumentException("Unsupported expression " + expr);
        }
        return rv;
    }

    @Override
    public T newInstance(Object ... args) {
        try {
            Object rv = this.getType().newInstance();
            BeanMap beanMap = new BeanMap(rv);
            for (Map.Entry<String, Expression<?>> entry : this.bindings.entrySet()) {
                Object value = args[this.args.indexOf(entry.getValue())];
                if (value == null) continue;
                beanMap.put(entry.getKey(), value);
            }
            return rv;
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QBean) {
            QBean c = (QBean)obj;
            return ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.args;
    }
}

