/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class OrderSpecifier<A extends Comparable>
implements Serializable {
    private static final long serialVersionUID = 3427652988262514678L;
    private final Order order;
    private final Expression<A> target;

    public OrderSpecifier(Order order, Expression<A> target) {
        this.order = (Order)((Object)Assert.notNull((Object)((Object)order), (String)"order"));
        this.target = (Expression)Assert.notNull(target, (String)"target");
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isAscending() {
        return this.order == Order.ASC;
    }

    public Expression<A> getTarget() {
        return this.target;
    }

    public String toString() {
        return this.target + " " + (Object)((Object)this.order);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrderSpecifier) {
            OrderSpecifier os = (OrderSpecifier)o;
            return os.order.equals((Object)this.order) && os.target.equals(this.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }
}

