/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;

public class ConstructorExpression<D>
extends ExpressionBase<D>
implements FactoryExpression<D> {
    private static final long serialVersionUID = -602747921848073175L;
    private final List<Expression<?>> args;
    private final Class<?>[] parameterTypes;
    @Nullable
    private transient Constructor<?> constructor;

    private static Class<?> normalize(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(clazz);
        }
        return clazz;
    }

    public static <D> ConstructorExpression<D> create(Class<D> type, Expression<?> ... args) {
        for (Constructor<?> c : type.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != args.length) continue;
            boolean found = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (ConstructorExpression.normalize(paramTypes[i]).isAssignableFrom(args[i].getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return new ConstructorExpression<D>(type, paramTypes, args);
        }
        throw new ExpressionException("Got no matching constructor");
    }

    public ConstructorExpression(Class<D> type, Class<?>[] paramTypes, Expression<?> ... args) {
        this(type, paramTypes, Arrays.asList(args));
    }

    public ConstructorExpression(Class<D> type, Class<?>[] paramTypes, List<Expression<?>> args) {
        super(type);
        this.parameterTypes = (Class[])paramTypes.clone();
        this.args = args;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConstructorExpression) {
            ConstructorExpression c = (ConstructorExpression)obj;
            return Arrays.equals(this.parameterTypes, c.parameterTypes) && ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    @Override
    public final List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public D newInstance(Object ... args) {
        try {
            if (this.constructor == null) {
                this.constructor = this.getType().getConstructor(this.parameterTypes);
            }
            return (D)this.constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }
}

