/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Projectable;
import com.mysema.query.SearchResults;
import com.mysema.query.support.QueryBase;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.IteratorUtils;

public abstract class ProjectableQuery<Q extends ProjectableQuery<Q>>
extends QueryBase<Q>
implements Projectable {
    public ProjectableQuery(QueryMixin<Q> queryMixin) {
        super(queryMixin);
    }

    @Override
    public long countDistinct() {
        this.queryMixin.setDistinct(true);
        return this.count();
    }

    @Override
    public boolean notExists() {
        return !this.exists();
    }

    @Override
    public final CloseableIterator<Object[]> iterate(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        return this.iterate(this.merge(first, second, rest));
    }

    @Override
    public final CloseableIterator<Object[]> iterateDistinct(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.iterate(first, second, rest);
    }

    @Override
    public final CloseableIterator<Object[]> iterateDistinct(Expression<?>[] args) {
        this.queryMixin.setDistinct(true);
        return this.iterate(args);
    }

    @Override
    public final <RT> CloseableIterator<RT> iterateDistinct(Expression<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.iterate(projection);
    }

    @Override
    public final List<Object[]> list(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        return this.list(this.merge(first, second, rest));
    }

    @Override
    public List<Object[]> list(Expression<?>[] args) {
        return IteratorUtils.toList(this.iterate(args));
    }

    @Override
    public <RT> List<RT> list(Expression<RT> projection) {
        return IteratorUtils.toList(this.iterate(projection));
    }

    @Override
    public final List<Object[]> listDistinct(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        this.queryMixin.setDistinct(true);
        return this.list(first, second, rest);
    }

    @Override
    public final List<Object[]> listDistinct(Expression<?>[] args) {
        this.queryMixin.setDistinct(true);
        return this.list(args);
    }

    @Override
    public final <RT> List<RT> listDistinct(Expression<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.list(projection);
    }

    @Override
    public final <RT> SearchResults<RT> listDistinctResults(Expression<RT> projection) {
        this.queryMixin.setDistinct(true);
        return this.listResults(projection);
    }

    @Override
    public final <K, V> Map<K, V> map(Expression<K> key, Expression<V> value) {
        List<Object[]> list = this.list(key, value, new Expression[0]);
        LinkedHashMap<Object, Object> results = new LinkedHashMap<Object, Object>(list.size());
        for (Object[] row : list) {
            results.put(row[0], row[1]);
        }
        return results;
    }

    private Expression<?>[] merge(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        Expression[] args = new Expression[rest.length + 2];
        args[0] = first;
        args[1] = second;
        System.arraycopy(rest, 0, args, 2, rest.length);
        return args;
    }

    @Override
    public final Object[] uniqueResult(Expression<?> first, Expression<?> second, Expression<?> ... rest) {
        return this.uniqueResult(this.merge(first, second, rest));
    }

    @Override
    public Object[] uniqueResult(Expression<?>[] args) {
        this.queryMixin.setUnique(true);
        CloseableIterator<Object[]> it = this.iterate(args);
        return it.hasNext() ? (Object[])it.next() : null;
    }

    @Override
    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.queryMixin.setUnique(true);
        this.limit(1L);
        CloseableIterator<RT> it = this.iterate(expr);
        return it.hasNext() ? (RT)it.next() : null;
    }
}

