/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.mysema.query.types.Constant;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.PredicateOperation;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.Templates;
import com.mysema.query.types.ToStringVisitor;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.template.BooleanTemplate;
import java.util.ArrayList;
import java.util.List;

public class CollectionAnyVisitor
implements Visitor<Expression<?>, Context> {
    public static final CollectionAnyVisitor DEFAULT = new CollectionAnyVisitor();
    public static final Templates TEMPLATE = new Templates(){
        {
            this.add(PathType.PROPERTY, "{0}_{1}");
            this.add(PathType.COLLECTION_ANY, "{0}");
        }
    };

    private static <T> Path<T> replaceParent(Path<T> path, Path<?> parent) {
        PathMetadata metadata = new PathMetadata(parent, path.getMetadata().getExpression(), path.getMetadata().getPathType());
        return new PathImpl(path.getType(), metadata);
    }

    @Override
    public Expression<?> visit(Constant<?> expr, Context context) {
        return expr;
    }

    @Override
    public Expression<?> visit(TemplateExpression<?> expr, Context context) {
        Expression[] args = new Expression[expr.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            Context c = new Context();
            args[i] = (Expression)expr.getArg(i).accept(this, c);
            context.add(c);
        }
        if (context.replace) {
            if (expr.getType().equals(Boolean.class)) {
                BooleanExpression predicate = BooleanTemplate.create(expr.getTemplate(), args);
                return !context.anyPaths.isEmpty() ? this.exists(context, predicate) : predicate;
            }
            return new TemplateExpressionImpl(expr.getType(), expr.getTemplate(), args);
        }
        return expr;
    }

    @Override
    public Expression<?> visit(FactoryExpression<?> expr, Context context) {
        return expr;
    }

    @Override
    public Expression<?> visit(Operation<?> expr, Context context) {
        Expression[] args = new Expression[expr.getArgs().size()];
        for (int i = 0; i < args.length; ++i) {
            Context c = new Context();
            args[i] = (Expression)expr.getArg(i).accept(this, c);
            context.add(c);
        }
        if (context.replace) {
            if (expr.getType().equals(Boolean.class)) {
                PredicateOperation predicate = new PredicateOperation(expr.getOperator(), args);
                return !context.anyPaths.isEmpty() ? this.exists(context, predicate) : predicate;
            }
            return new OperationImpl(expr.getType(), expr.getOperator(), args);
        }
        return expr;
    }

    protected Predicate exists(Context c, Predicate condition) {
        return condition;
    }

    @Override
    public Expression<?> visit(Path<?> expr, Context context) {
        if (expr.getMetadata().getPathType() == PathType.COLLECTION_ANY) {
            String variable = expr.accept(ToStringVisitor.DEFAULT, TEMPLATE).replace('.', '_');
            EntityPathBase replacement = new EntityPathBase(expr.getType(), variable);
            context.add(expr, replacement);
            return replacement;
        }
        if (expr.getMetadata().getParent() != null) {
            Context c = new Context();
            Path parent = (Path)expr.getMetadata().getParent().accept(this, c);
            if (c.replace) {
                context.add(c);
                return CollectionAnyVisitor.replaceParent(expr, parent);
            }
        }
        return expr;
    }

    @Override
    public Expression<?> visit(SubQueryExpression<?> expr, Context context) {
        return expr;
    }

    @Override
    public Expression<?> visit(ParamExpression<?> expr, Context context) {
        return expr;
    }

    public static class Context {
        public boolean replace;
        public final List<Path<?>> anyPaths = new ArrayList();
        public final List<EntityPath<?>> replacements = new ArrayList();

        public void add(Path<?> anyPath, EntityPath<?> replacement) {
            this.replace = true;
            this.anyPaths.add(anyPath);
            this.replacements.add(replacement);
        }

        public void add(Context c) {
            this.replace |= c.replace;
            this.anyPaths.addAll(c.anyPaths);
            this.replacements.addAll(c.replacements);
        }

        public void clear() {
            this.anyPaths.clear();
            this.replacements.clear();
        }
    }
}

