/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.TypeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class Method {
    private final Type declaringType;
    private final String name;
    private final List<Parameter> parameters;
    private final Type returnType;
    private final String template;

    public Method(Type declaringType, String name, String template, Type returnType) {
        this(declaringType, name, template, Collections.emptyList(), returnType);
    }

    public Method(Type declaringType, String name, String template, List<Parameter> params, Type returnType) {
        this.declaringType = (Type)Assert.notNull((Object)declaringType, (String)"declaringType");
        this.name = (String)Assert.notNull((Object)name, (String)"name");
        this.template = (String)Assert.notNull((Object)template, (String)"template");
        this.parameters = (List)Assert.notNull(params, (String)"params");
        this.returnType = (Type)Assert.notNull((Object)returnType, (String)"returnType");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Method) {
            Method m = (Method)o;
            return m.name.equals(this.name) && ((Object)m.parameters).equals(this.parameters);
        }
        return false;
    }

    public Method createCopy(EntityType model) {
        Type newReturnType = TypeResolver.resolve(this.returnType, this.declaringType, model);
        if (newReturnType.getCategory() == TypeCategory.ENTITY) {
            newReturnType = newReturnType.as(TypeCategory.SIMPLE);
        }
        ArrayList<Parameter> newParameters = new ArrayList<Parameter>();
        for (Parameter param : this.parameters) {
            Type newType = TypeResolver.resolve(param.getType(), this.declaringType, model);
            newParameters.add(new Parameter(param.getName(), newType));
        }
        if (!newReturnType.equals(this.returnType) || !((Object)newParameters).equals(this.parameters)) {
            return new Method(this.declaringType, this.name, this.template, newParameters, newReturnType);
        }
        return this;
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getTemplate() {
        return this.template;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.declaringType.getFullName() + "." + this.name + " " + this.parameters;
    }
}

