/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeAdapter;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Supertype;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class EntityType
extends TypeAdapter
implements Comparable<EntityType> {
    private final Map<Class<?>, Annotation> annotations = new HashMap();
    private final Set<Constructor> constructors = new HashSet<Constructor>();
    private int escapeSuffix = 1;
    private final Set<Method> methods = new HashSet<Method>();
    private final Set<Delegate> delegates = new HashSet<Delegate>();
    private final String prefix;
    private final Set<Property> properties = new TreeSet<Property>();
    private final Set<String> propertyNames = new HashSet<String>();
    private final Set<String> escapedPropertyNames = new HashSet<String>();
    private final Collection<Supertype> superTypes;
    private final Map<Object, Object> data = new HashMap<Object, Object>();
    private String uncapSimpleName;

    public EntityType(String prefix, Type type) {
        this(prefix, type, new HashSet<Supertype>());
    }

    public EntityType(String prefix, Type type, Set<Supertype> superTypes) {
        super(type);
        this.prefix = (String)Assert.notNull((Object)prefix, (String)"prefix");
        this.uncapSimpleName = StringUtils.uncapitalize((String)type.getSimpleName());
        this.superTypes = superTypes;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
    }

    public void addConstructor(Constructor co) {
        this.constructors.add(co);
    }

    public void addDelegate(Delegate delegate) {
        this.delegates.add(delegate);
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public void addProperty(Property field) {
        this.propertyNames.add(field.getName());
        this.escapedPropertyNames.add(field.getEscapedName());
        this.properties.add(this.validateField(field));
    }

    public void addSupertype(Supertype entityType) {
        this.superTypes.add(entityType);
    }

    @Override
    public int compareTo(EntityType o) {
        return this.getType().getSimpleName().compareTo(o.getType().getSimpleName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Type) {
            return this.getFullName().equals(((Type)o).getFullName());
        }
        return false;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return (T)this.annotations.get(type);
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    public TypeCategory getCategory() {
        if (this.getType().getCategory() == TypeCategory.ENTITY || !this.properties.isEmpty()) {
            return TypeCategory.ENTITY;
        }
        return TypeCategory.CUSTOM;
    }

    public Set<Constructor> getConstructors() {
        return this.constructors;
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public Set<Delegate> getDelegates() {
        return this.delegates;
    }

    public String getFullName() {
        String name = super.getFullName();
        return name.startsWith("java.") ? "ext." + name : name;
    }

    public Set<Method> getMethods() {
        return this.methods;
    }

    public TypeCategory getOriginalCategory() {
        return super.getCategory();
    }

    public String getPackageName() {
        String pkg = super.getPackageName();
        return pkg.startsWith("java.") ? "ext." + pkg : pkg;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    @Nullable
    public Supertype getSuperType() {
        return this.superTypes.size() == 1 ? this.superTypes.iterator().next() : null;
    }

    public Collection<Supertype> getSuperTypes() {
        return this.superTypes;
    }

    public String getUncapSimpleName() {
        return this.uncapSimpleName;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean hasEntityFields() {
        return this.hasPropertyWithType(TypeCategory.ENTITY);
    }

    public boolean hasLists() {
        return this.hasPropertyWithType(TypeCategory.LIST);
    }

    public boolean hasMaps() {
        return this.hasPropertyWithType(TypeCategory.MAP);
    }

    private boolean hasPropertyWithType(TypeCategory category) {
        for (Property property : this.properties) {
            if (property.getType().getCategory() != category) continue;
            return true;
        }
        return false;
    }

    public void include(Supertype supertype) {
        EntityType entityType = supertype.getEntityType();
        for (Method method : entityType.getMethods()) {
            this.addMethod(method.createCopy(this));
        }
        for (Delegate delegate : entityType.getDelegates()) {
            this.addDelegate(delegate);
        }
        for (Property property : entityType.getProperties()) {
            this.addProperty(property.createCopy(this));
        }
    }

    private Property validateField(Property field) {
        if (field.getName().equals(this.uncapSimpleName) || field.getEscapedName().equals(this.uncapSimpleName)) {
            this.uncapSimpleName = StringUtils.uncapitalize((String)this.getType().getSimpleName()) + this.escapeSuffix++;
        }
        return field;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Set<String> getEscapedPropertyNames() {
        return this.escapedPropertyNames;
    }
}

