/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import com.mysema.util.AnnotatedElementAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class ReflectionUtils {
    private static final AnnotatedElement EMPTY = new AnnotatedElementAdapter(new AnnotatedElement[0]);

    private ReflectionUtils() {
    }

    public static AnnotatedElement getAnnotatedElement(Class<?> beanClass, String propertyName, Class<?> propertyClass) {
        Field field = ReflectionUtils.getFieldOrNull(beanClass, propertyName);
        Method method = ReflectionUtils.getGetterOrNull(beanClass, propertyName, propertyClass);
        if (field == null || field.getAnnotations().length == 0) {
            return method != null && method.getAnnotations().length > 0 ? method : EMPTY;
        }
        if (method == null || method.getAnnotations().length == 0) {
            return field;
        }
        return new AnnotatedElementAdapter(field, method);
    }

    @Nullable
    private static Field getFieldOrNull(Class<?> beanClass, String propertyName) {
        while (beanClass != null && !beanClass.equals(Object.class)) {
            try {
                return beanClass.getDeclaredField(propertyName);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    @Nullable
    private static Method getGetterOrNull(Class<?> beanClass, String name, Class<?> type) {
        String methodName = (type.equals(Boolean.class) ? "is" : "get") + StringUtils.capitalize((String)name);
        while (beanClass != null && !beanClass.equals(Object.class)) {
            try {
                return beanClass.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    @Nullable
    public static Class<?> getTypeParameter(Type type, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] targs = ptype.getActualTypeArguments();
            if (targs[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)targs[index];
                return (Class)wildcardType.getUpperBounds()[0];
            }
            if (targs[index] instanceof TypeVariable) {
                return (Class)((TypeVariable)targs[index]).getGenericDeclaration();
            }
            if (targs[index] instanceof ParameterizedType) {
                return (Class)((ParameterizedType)targs[index]).getRawType();
            }
            return (Class)targs[index];
        }
        return null;
    }
}

