/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.path.PArray;
import com.mysema.query.types.path.PBoolean;
import com.mysema.query.types.path.PCollection;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PList;
import com.mysema.query.types.path.PMap;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSet;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PString;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.PathMetadataFactory;
import java.util.HashMap;
import java.util.Map;

public final class PathBuilder<D>
extends PEntity<D> {
    private static final long serialVersionUID = -1666357914232685088L;
    private final Map<String, PathBuilder<?>> properties = new HashMap();

    public PathBuilder(Class<? extends D> type, PathMetadata<?> pathMetadata) {
        super(type, pathMetadata);
    }

    public PathBuilder(Class<? extends D> type, String variable) {
        super(type, PathMetadataFactory.forVariable(variable));
    }

    public PathBuilder<Object> get(String property) {
        PathBuilder<Object> path = this.properties.get(property);
        if (path == null) {
            path = new PathBuilder<Object>(Object.class, this.forProperty(property));
            this.properties.put(property, path);
        }
        return path;
    }

    public <A> PathBuilder<A> get(String property, Class<A> type) {
        PathBuilder<Object> path = this.properties.get(property);
        if (path == null || !type.isAssignableFrom(path.getType())) {
            path = new PathBuilder<A>(type, this.forProperty(property));
            this.properties.put(property, path);
        }
        return path;
    }

    public <A> PArray<A> getArray(String property, Class<A[]> type) {
        return super.createArray(property, type);
    }

    public PBoolean get(PBoolean path) {
        return this.getBoolean(this.toString(path));
    }

    public PBoolean getBoolean(String propertyName) {
        return super.createBoolean(propertyName);
    }

    public <A> PCollection<A> getCollection(String property, Class<A> type) {
        return super.createCollection(property, type);
    }

    public <A extends Comparable<?>> PComparable<A> get(PComparable<A> path) {
        return this.getComparable(this.toString(path), path.getType());
    }

    public <A extends Comparable<?>> PComparable<A> getComparable(String property, Class<A> type) {
        return super.createComparable(property, type);
    }

    public <A extends Comparable<?>> PDate<A> get(PDate<A> path) {
        return this.getDate(this.toString(path), path.getType());
    }

    public <A extends Comparable<?>> PDate<A> getDate(String property, Class<A> type) {
        return super.createDate(property, type);
    }

    public <A extends Comparable<?>> PDateTime<A> get(PDateTime<A> path) {
        return this.getDateTime(this.toString(path), path.getType());
    }

    public <A extends Comparable<?>> PDateTime<A> getDateTime(String property, Class<A> type) {
        return super.createDateTime(property, type);
    }

    public <A> PList<A, PathBuilder<A>> getList(String property, Class<A> type) {
        return super.createList(property, type, PathBuilder.class);
    }

    public <A, E extends Expr<A>> PList<A, E> getList(String property, Class<A> type, Class<E> queryType) {
        return super.createList(property, type, queryType);
    }

    public <K, V> PMap<K, V, PathBuilder<V>> getMap(String property, Class<K> key, Class<V> value) {
        return super.createMap(property, key, value, PathBuilder.class);
    }

    public <K, V, E extends Expr<V>> PMap<K, V, E> getMap(String property, Class<K> key, Class<V> value, Class<E> queryType) {
        return super.createMap(property, key, value, queryType);
    }

    public <A extends Number> PNumber<A> get(PNumber<A> path) {
        return this.getNumber(this.toString(path), path.getType());
    }

    public <A extends Number> PNumber<A> getNumber(String property, Class<A> type) {
        return super.createNumber(property, type);
    }

    public <A> PSet<A> getSet(String property, Class<A> type) {
        return super.createSet(property, type);
    }

    public <A> Path<A> get(Path<A> path) {
        return this.getSimple(this.toString(path), path.getType());
    }

    public <A> PSimple<A> getSimple(String property, Class<A> type) {
        return super.createSimple(property, type);
    }

    public PString get(PString path) {
        return this.getString(this.toString(path));
    }

    public PString getString(String property) {
        return super.createString(property);
    }

    public <A extends Comparable<?>> PTime<A> get(PTime<A> path) {
        return this.getTime(this.toString(path), path.getType());
    }

    public <A extends Comparable<?>> PTime<A> getTime(String property, Class<A> type) {
        return super.createTime(property, type);
    }

    private String toString(Path<?> path) {
        return path.getMetadata().getExpression().toString();
    }
}

