/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Expr;
import com.mysema.query.types.ExprException;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EMapBase;
import com.mysema.query.types.path.PComparable;
import com.mysema.query.types.path.PDate;
import com.mysema.query.types.path.PDateTime;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PNumber;
import com.mysema.query.types.path.PSimple;
import com.mysema.query.types.path.PTime;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathMetadataFactory;
import com.mysema.query.types.path.PathMixin;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PMap<K, V, E extends Expr<V>>
extends EMapBase<K, V>
implements Path<Map<K, V>> {
    private static final long serialVersionUID = -9113333728412016832L;
    private static final Set<Class<?>> typedClasses = new HashSet<Class>(Arrays.asList(PathBuilder.class, PComparable.class, PDate.class, PDateTime.class, PEntity.class, PNumber.class, PSimple.class, PTime.class));
    private final Class<K> keyType;
    private final Path<Map<K, V>> pathMixin;
    private final Class<E> queryType;
    @Nullable
    private transient Constructor<E> constructor;
    private final Class<V> valueType;

    public PMap(Class<? super K> keyType, Class<? super V> valueType, Class<E> queryType, PathMetadata<?> metadata) {
        super(Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
        this.queryType = queryType;
        this.pathMixin = new PathMixin<Map<K, V>>(this, metadata);
    }

    protected PathMetadata<K> forMapAccess(K key) {
        return PathMetadataFactory.forMapAccess(this, key);
    }

    protected PathMetadata<K> forMapAccess(Expr<K> key) {
        return PathMetadataFactory.forMapAccess(this, key);
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    public E get(Expr<K> key) {
        try {
            PathMetadata<K> md = this.forMapAccess(key);
            return this.newInstance(md);
        }
        catch (NoSuchMethodException e) {
            throw new ExprException(e);
        }
        catch (InstantiationException e) {
            throw new ExprException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExprException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExprException(e);
        }
    }

    public E get(K key) {
        try {
            PathMetadata<K> md = this.forMapAccess(key);
            return this.newInstance(md);
        }
        catch (NoSuchMethodException e) {
            throw new ExprException(e);
        }
        catch (InstantiationException e) {
            throw new ExprException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExprException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExprException(e);
        }
    }

    @Override
    public Class<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public Class<V> getValueType() {
        return this.valueType;
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public EBoolean isNotNull() {
        return this.pathMixin.isNotNull();
    }

    @Override
    public EBoolean isNull() {
        return this.pathMixin.isNull();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    private E newInstance(PathMetadata<?> pm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.constructor == null) {
            this.constructor = typedClasses.contains(this.queryType) ? this.queryType.getConstructor(Class.class, PathMetadata.class) : this.queryType.getConstructor(PathMetadata.class);
        }
        if (typedClasses.contains(this.queryType)) {
            return (E)((Expr)this.constructor.newInstance(this.getValueType(), pm));
        }
        return (E)((Expr)this.constructor.newInstance(pm));
    }
}

